/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client;

import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.FileClientManager;
import cn.com.yusys.yusp.commons.file.client.FileClientPool;
import cn.com.yusys.yusp.commons.file.client.PooledFileClientCommandFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractFileClient<T extends ConnectConfig>
implements FileClient,
InitializingBean,
BeanNameAware,
DisposableBean {
    private String clientId;
    private String homePath = "/";
    private final T connectConfig;
    private final GenericObjectPoolConfig<FileClientCommand> poolConfig;
    private FileClientPool pool = null;

    public AbstractFileClient(String clientId, T connectConfig, GenericObjectPoolConfig<FileClientCommand> poolConfig) {
        this.clientId = clientId;
        this.connectConfig = connectConfig;
        this.poolConfig = poolConfig;
    }

    @Override
    public String getClientInfo() {
        return this.getFileSystemType() + ":" + this.clientId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public String getHomePath() {
        return this.homePath;
    }

    public void afterPropertiesSet() throws Exception {
        if (FilenameUtils.getPrefixLength((String)this.homePath) <= 0) {
            throw new FileSystemException("Home path is not a root path");
        }
        if (!this.homePath.endsWith("/")) {
            this.homePath = this.homePath.concat("/");
        }
        if (this.poolConfig != null) {
            PooledFileClientCommandFactory factory = new PooledFileClientCommandFactory(this);
            this.pool = new FileClientPool(factory, this.poolConfig);
        }
        FileClientManager.registerFileClient(this.clientId, this);
    }

    @Override
    public FileClientCommand getCommand() {
        if (this.pool == null) {
            return this.createCommand(this.connectConfig);
        }
        try {
            return (FileClientCommand)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new FileSystemException("Could not get a command from the pool", e);
        }
    }

    protected FileClientCommand createCommand(T connect) {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public void setBeanName(String name) {
        this.clientId = name;
    }

    protected T getConnectConfig() {
        return this.connectConfig;
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }
}

