/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.sftp;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.AbstractDefaultOutputStream;
import cn.com.yusys.yusp.commons.file.client.sftp.BasicConnection;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpConfig;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpConnection;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpFileClient;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpFileInfo;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileClientCommand
implements FileClientCommand {
    private static final Logger logger = LoggerFactory.getLogger(SftpFileClientCommand.class);
    private BasicConnection sftpConnection;
    private final SftpFileClient sftpFileServer;
    private final SftpConfig sftpConfig;

    public SftpFileClientCommand(SftpConfig sftpConfig, SftpFileClient sftpFileServer) {
        this.sftpConfig = sftpConfig;
        this.sftpConnection = new SftpConnection(sftpConfig);
        this.sftpFileServer = sftpFileServer;
        if (!this.sftpConnection.login()) {
            throw new FileSystemException("Sftp server connect failed.");
        }
    }

    public void close() {
        if (this.sftpConnection != null) {
            this.sftpConnection.disconnect();
        }
    }

    public FileInfo upload(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullRemotePath = this.getFullFilePath(remotePath);
        String fullLocalPath = this.getFullLocalFilePath(localPath);
        try {
            String errorMessage = String.format("sftp server upload file failure! localPath: %s, localFileName: %s, remotePath: %s, remoteFileName: %s", localPath, localFileName, remotePath, remoteFileName);
            File localFile = new File(StringUtils.builder0((Object[])new Object[]{fullLocalPath, File.separator, localFileName}));
            Asserts.isTrue((boolean)localFile.exists(), (Object[])new Object[]{errorMessage});
            logger.debug("sftp server >>> upload: {}/{} to {}/{}", new Object[]{fullLocalPath, localFileName, fullRemotePath, remoteFileName});
            if (this.sftpConnection.upload(fullLocalPath, localFileName, fullRemotePath, remoteFileName)) {
                return this.queryFileInfo(remoteFileName, remotePath);
            }
            throw new FileSystemException(errorMessage);
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileSystemException("sftp file upload failure! cause by:" + e.getMessage(), (Throwable)e);
        }
    }

    public boolean download(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullRemotePath = this.getFullFilePath(remotePath);
        String fullLocalPath = this.getFullLocalFilePath(localPath);
        try {
            logger.debug("sftp server >>> download: {}/{} to {}/{}", new Object[]{fullRemotePath, remoteFileName, fullLocalPath, localFileName});
            return this.sftpConnection.download(fullLocalPath, localFileName, fullRemotePath, remoteFileName);
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractUploadStream openUploadStream(String fileName, String remotePath, long size) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullFilePath = this.getFullFilePath(remotePath);
        try {
            logger.debug("sftp server >>> openUploadStream: {}/{}", (Object)fullFilePath, (Object)fileName);
            OutputStream os = this.sftpConnection.openUploadStream(fullFilePath, fileName);
            return new SftpOutputStream(os, size, fileName, remotePath);
        }
        catch (Exception e) {
            logger.error("sftp server openUploadStream error", (Throwable)e);
            throw new FileSystemException(String.format("sftp server openUploadStream error: %s%s: %s", fullFilePath, fileName, e.getMessage()), (Throwable)e);
        }
    }

    public InputStream openDownloadStream(String fileName, String remotePath) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullFilePath = this.getFullFilePath(remotePath);
        try {
            logger.debug("sftp server >>> openDownloadStream: {}/{}", (Object)fullFilePath, (Object)fileName);
            return this.sftpConnection.openDownloadStream(fullFilePath, fileName);
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public boolean delete(String fileName, String remotePath) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        boolean result = false;
        String fullFilePath = this.getFullFilePath(remotePath);
        try {
            logger.debug("sftp server >>> remove file: {}/{}", (Object)fullFilePath, (Object)fileName);
            result = this.sftpConnection.removeFile(fullFilePath, fileName);
        }
        catch (Exception e) {
            logger.error(String.format("path:%s, name:%s delete failure!, cause by:%s", remotePath, fileName, e.getMessage()));
        }
        return result;
    }

    public boolean deleteFolder(String remotePath) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullFilePath = this.getFullFilePath(remotePath);
        try {
            if (!this.sftpConnection.isFolderExist(fullFilePath)) {
                logger.error("Folder:{} delete failed, no such folder or path not a directory!", (Object)fullFilePath);
                return false;
            }
            List<String> files = this.sftpConnection.listFile(fullFilePath);
            for (String file : files) {
                if (this.delete(file, remotePath)) continue;
                return false;
            }
            List<String> dirs = this.sftpConnection.listDir(fullFilePath);
            for (String dir : dirs) {
                String fullDirName = FilePathUtils.concatRelativePath((String)remotePath, (String)dir);
                if (this.deleteFolder(fullDirName)) continue;
                return false;
            }
            if (!this.sftpConnection.removeFolder(fullFilePath)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("sftp server remove folder error", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isFileExists(String fileName, String remotePath) {
        this.reconnectAfterCheckingUnavailability();
        boolean result = false;
        String fullFilePath = this.getFullFilePath(remotePath);
        try {
            logger.debug("sftp server >>> isFileExist: {}/{}", (Object)fullFilePath, (Object)fileName);
            result = this.sftpConnection.isFileExist(fullFilePath, fileName);
        }
        catch (Exception e) {
            logger.error("sftp server isFileExists error", (Throwable)e);
        }
        return result;
    }

    public boolean isFolderExists(String remotePath) {
        boolean result;
        this.reconnectAfterCheckingUnavailability();
        String fullFolderPath = this.getFullFilePath(remotePath);
        try {
            logger.debug("sftp server >>> isFolderExists: {}", (Object)fullFolderPath);
            result = this.sftpConnection.isFolderExist(fullFolderPath);
        }
        catch (Exception e) {
            logger.error("sftp server isFolderExists error", (Throwable)e);
            result = false;
        }
        return result;
    }

    public FileInfo queryFileInfo(String fileName, String remotePath) {
        this.reconnectAfterCheckingUnavailability();
        SftpFileInfo fileInfo = new SftpFileInfo((FileClient)this.sftpFileServer);
        fileInfo.setFileName(fileName);
        fileInfo.setFilePath(remotePath);
        logger.debug("sftp server >>> queryFileInfo: {}/{}", (Object)this.getFullFilePath(remotePath), (Object)fileName);
        if (this.isFileExists(fileName, remotePath)) {
            Date date;
            fileInfo.setExists(true);
            String fullFilePath = this.getFullFilePath(remotePath);
            long size = 0L;
            try {
                size = this.sftpConnection.queryFileSize(fullFilePath, fileName);
            }
            catch (Exception e) {
                logger.error("sftp server queryFileSize error", (Throwable)e);
            }
            fileInfo.setFileSize(size);
            try {
                date = new Date(this.sftpConnection.queryUploadDate(fullFilePath, fileName));
            }
            catch (Exception e) {
                logger.error("sftp server queryUploadDate error", (Throwable)e);
                date = new Date();
            }
            fileInfo.setUploadDate(date);
        } else {
            fileInfo.setExists(false);
            fileInfo.setFileSize(0L);
            fileInfo.setUploadDate(new Date());
        }
        return fileInfo;
    }

    public List<FileInfo> queryFiles(String remotePath) {
        this.reconnectAfterCheckingUnavailability();
        String fullRemoteFilePath = this.getFullFilePath(remotePath);
        List fileInfos = null;
        try {
            logger.debug("sftp server >>> queryFiles: {}", (Object)fullRemoteFilePath);
            List<String> fileNames = this.sftpConnection.listFile(fullRemoteFilePath);
            if (CollectionUtils.nonEmpty(fileNames)) {
                fileInfos = ListUtils.newArrayListWithCapacity((int)fileNames.size());
                for (String fileName : fileNames) {
                    FileInfo fileInfo = this.queryFileInfo(fileName, remotePath);
                    fileInfos.add(fileInfo);
                }
            }
        }
        catch (Exception e) {
            logger.warn("sftp server >>>  queryFiles: remotePath not exists {}", (Object)remotePath, (Object)e);
        }
        return Objects.nonNull(fileInfos) ? fileInfos : Collections.emptyList();
    }

    public List<String> querySubFolder(String remotePath) {
        this.reconnectAfterCheckingUnavailability();
        String fullRemoteFilePath = this.getFullFilePath(remotePath);
        Object subFolders = null;
        try {
            logger.debug("sftp server >>> querySubFolder: {}", (Object)fullRemoteFilePath);
            return this.sftpConnection.listDir(fullRemoteFilePath);
        }
        catch (Exception e) {
            logger.warn(String.format("sftp server >>>  querySubFolder: remotePath not exists %s", remotePath), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean move(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullOriginPath = this.getFullFilePath(originPath);
        String fullTargetPath = this.getFullFilePath(targetPath);
        boolean result = this.sftpConnection.move(fileName, fullOriginPath, targetFileName, fullTargetPath, isOverwrite);
        logger.info("File move success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{originPath, fileName, targetPath, targetFileName});
        if (!result) {
            throw new FileSystemException("sftp server move file error");
        }
        return true;
    }

    public boolean copy(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        this.reconnectAfterCheckingUnavailability();
        String fullOriginPath = this.getFullFilePath(originPath);
        String fullTargetPath = this.getFullFilePath(targetPath);
        boolean result = this.sftpConnection.copy(fileName, fullOriginPath, targetFileName, fullTargetPath, isOverwrite);
        logger.info("File copy success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{originPath, fileName, targetPath, targetFileName});
        return result;
    }

    public boolean available() {
        return Objects.nonNull(this.sftpConnection) && this.sftpConnection.isConnected();
    }

    private String getFullFilePath(String remotePath) {
        String homePath = this.sftpFileServer.getHomePath();
        String filePath = FilePathUtils.concatRelativePath((String)homePath, (String)remotePath);
        return FilePathUtils.pathEscape((String)filePath);
    }

    private String getFullLocalFilePath(String localPath) {
        return FilePathUtils.concatRelativePath(null, (String)localPath);
    }

    private void reconnectAfterCheckingUnavailability() {
        if (!this.sftpConnection.isConnected()) {
            this.sftpConnection.disconnect();
            logger.warn("The current sftp server connection is unavailable, re-create the connection!");
            this.sftpConnection = new SftpConnection(this.sftpConfig);
            if (!this.sftpConnection.login()) {
                throw new FileSystemException("Sftp server connect failed.");
            }
        }
    }

    class SftpOutputStream
    extends AbstractDefaultOutputStream {
        private final String fileName;
        private final String remotePath;

        public SftpOutputStream(OutputStream innerStream, long maxSize, String fileName, String remotePath) {
            super(innerStream, maxSize);
            this.fileName = fileName;
            this.remotePath = remotePath;
        }

        protected void closeError(OutputStream innerStream) throws IOException {
            logger.error("SFtpOutputStream close error");
            innerStream.close();
            SftpFileClientCommand.this.delete(this.fileName, this.remotePath);
        }

        protected FileInfo closeSuccess(OutputStream innerStream) throws IOException {
            innerStream.close();
            return SftpFileClientCommand.this.queryFileInfo(this.fileName, this.remotePath);
        }
    }
}

