/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.sftp;

import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.sftp.BasicConnection;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpConfig;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpConnection
implements BasicConnection {
    private static final Logger logger = LoggerFactory.getLogger(SftpConnection.class);
    private ChannelSftp channelSftp;
    private Session session;
    private final SftpConfig sftpConfig;
    private static final String LOCAL_DIR = ".";
    private static final String PARENT_DIR = "..";
    private static final char FILE_PATH_WINDOWS_CHAR = ':';
    private static final int FILE_PATH_WINDOWS_LEN = 2;

    public SftpConnection(SftpConfig sftpConfig) {
        Asserts.nonNull((Object)((Object)sftpConfig), (Object[])new Object[]{"sftp config must not be null!"});
        this.sftpConfig = sftpConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws FileSystemException {
        boolean connected = true;
        String host = this.sftpConfig.getHost();
        int port = this.sftpConfig.getPort();
        String username = this.sftpConfig.getUsername();
        String password = this.sftpConfig.getPassword();
        String encoding = this.sftpConfig.getEncoding();
        int connectTimeout = this.sftpConfig.getConnectTimeout();
        try {
            JSch jSch = new JSch();
            this.session = jSch.getSession(username, host, port);
            this.session.setPassword(password);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            this.session.setConfig(properties);
            this.session.setTimeout(connectTimeout);
            this.session.connect();
            String uploadChannel = "sftp";
            this.channelSftp = (ChannelSftp)this.session.openChannel(uploadChannel);
            this.channelSftp.connect();
            Field fEncoding = this.channelSftp.getClass().getDeclaredField("fEncoding");
            fEncoding.setAccessible(true);
            fEncoding.set(this.channelSftp, encoding);
            Field isEncoding = this.channelSftp.getClass().getDeclaredField("fEncoding_is_utf8");
            isEncoding.setAccessible(true);
            isEncoding.set(this.channelSftp, false);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            connected = false;
        }
        finally {
            if (!connected) {
                this.disconnect();
            }
        }
        return connected;
    }

    @Override
    public boolean removeFile(String path, String fileName) throws FileSystemException {
        try {
            this.getChannelSftp().rm(StringUtils.builder0((Object[])new Object[]{this.formatFilePath(path), fileName}));
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
        return true;
    }

    @Override
    public boolean removeFolder(String path) throws FileSystemException {
        try {
            this.getChannelSftp().rmdir(this.formatFilePath(path));
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
        return true;
    }

    @Override
    public boolean isFileExist(String path, String fileName) throws FileSystemException {
        return this.isFileExist(StringUtils.builder0((Object[])new Object[]{this.formatFilePath(path), fileName}));
    }

    private boolean isFileExist(String file) throws FileSystemException {
        boolean result;
        try {
            SftpATTRS sftpATTRS = this.getChannelSftp().lstat(file);
            result = !sftpATTRS.isDir() && !sftpATTRS.isLink();
        }
        catch (SftpException e) {
            if (2 == e.id) {
                result = false;
            }
            throw new FileSystemException((Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isFolderExist(String path) throws FileSystemException {
        boolean result;
        String remotePath = this.formatFilePath(path);
        try {
            SftpATTRS sftpATTRS = this.getChannelSftp().lstat(remotePath);
            result = sftpATTRS.isDir();
        }
        catch (SftpException e) {
            if (2 == e.id) {
                result = false;
            }
            throw new FileSystemException((Throwable)e);
        }
        return result;
    }

    @Override
    public long queryFileSize(String path, String fileName) throws FileSystemException {
        try {
            SftpATTRS sftpATTRS = this.getChannelSftp().lstat(StringUtils.buffer0((Object[])new Object[]{this.formatFilePath(path), fileName}));
            return sftpATTRS.getSize();
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    public long queryUploadDate(String path, String fileName) throws FileSystemException {
        try {
            SftpATTRS sftpATTRS = this.getChannelSftp().lstat(StringUtils.buffer0((Object[])new Object[]{this.formatFilePath(path), fileName}));
            int seconds = sftpATTRS.getMTime();
            return (long)seconds * 1000L;
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    public OutputStream openUploadStream(String path, String fileName) throws FileSystemException {
        this.createDirIfNotExist(path);
        try {
            return this.getChannelSftp().put(StringUtils.builder0((Object[])new Object[]{this.formatFilePath(path), fileName}), 0);
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    public InputStream openDownloadStream(String path, String fileName) throws FileSystemException {
        try {
            return this.getChannelSftp().get(StringUtils.buffer0((Object[])new Object[]{this.formatFilePath(path), fileName}));
        }
        catch (SftpException e) {
            String errorMessage = e.id == 2 && "No such file".equals(e.getMessage()) ? String.format("File Not Found: [%s%s]", this.formatFilePath(path), fileName) : null;
            throw Objects.nonNull(errorMessage) ? new FileSystemException(errorMessage) : new FileSystemException((Throwable)e);
        }
    }

    @Override
    public boolean upload(String localPath, String fileName, String remotePath, String remoteFileName) throws FileSystemException {
        this.createDirIfNotExist(remotePath);
        return this.uploadFile(StringUtils.builder0((Object[])new Object[]{this.formatLocalFilePath(localPath), fileName}), StringUtils.builder0((Object[])new Object[]{this.formatFilePath(remotePath), remoteFileName}));
    }

    @Override
    public void upload(InputStream is, String remotePath, String remoteFileName) throws FileSystemException {
        this.createDirIfNotExist(remotePath);
        try {
            this.getChannelSftp().put(is, StringUtils.builder0((Object[])new Object[]{this.formatFilePath(remotePath), remoteFileName}), 0);
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    public boolean download(String localPath, String fileName, String remotePath, String remoteFileName) throws FileSystemException {
        String localFilePath = this.formatLocalFilePath(localPath);
        this.createLocalDirIfNotExist(localFilePath);
        return this.downloadFile(StringUtils.builder0((Object[])new Object[]{localFilePath, fileName}), StringUtils.builder0((Object[])new Object[]{this.formatFilePath(remotePath), remoteFileName}));
    }

    @Override
    public boolean move(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        if (!this.copy(fileName, originPath, targetFileName, targetPath, isOverwrite)) {
            return false;
        }
        return this.removeFile(originPath, fileName);
    }

    @Override
    public boolean copy(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        if (!this.isFileExist(originPath, fileName)) {
            throw new FileSystemException(String.format("Source file:%s not found!", FilePathUtils.getAbsolutePath((String)originPath, (String)fileName)));
        }
        if (this.isFileExist(targetPath, targetFileName) && !isOverwrite) {
            throw new FileSystemException(String.format("Source file:%s, copy to target file:%s failure! cause by: target file exist and over write is false!", FilePathUtils.getAbsolutePath((String)originPath, (String)fileName), FilePathUtils.getAbsolutePath((String)targetPath, (String)targetFileName)));
        }
        if (!this.isFileExist(originPath, fileName)) {
            throw new FileSystemException(String.format("Source file:%s not found!", FilePathUtils.getAbsolutePath((String)originPath, (String)fileName)));
        }
        try {
            File tempFile = FileInfoUtils.createTempFile((String)fileName);
            try (InputStream is = this.openDownloadStream(originPath, fileName);
                 FileOutputStream os = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            return this.upload(tempFile.getParentFile().getAbsolutePath(), tempFile.getName(), targetPath, targetFileName);
        }
        catch (FileSystemException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    public List<String> listFile(String remotePath) throws FileSystemException {
        ArrayList<String> fileList = new ArrayList<String>();
        String remoteDirPath = this.formatFilePath(remotePath);
        try {
            Vector lsEntries = this.getChannelSftp().ls(remoteDirPath);
            lsEntries.stream().filter(lsEntry -> !lsEntry.getAttrs().isDir()).forEach(lsEntry -> fileList.add(lsEntry.getFilename()));
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
        return fileList;
    }

    @Override
    public List<String> listDir(String remotePath) throws FileSystemException {
        ArrayList<String> dirList = new ArrayList<String>();
        String remoteDirPath = this.formatFilePath(remotePath);
        try {
            Vector lsEntries = this.getChannelSftp().ls(remoteDirPath);
            for (ChannelSftp.LsEntry lsEntry : lsEntries) {
                if (!lsEntry.getAttrs().isDir() || LOCAL_DIR.equals(lsEntry.getFilename().trim()) || PARENT_DIR.equals(lsEntry.getFilename().trim())) continue;
                dirList.add(lsEntry.getFilename());
            }
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
        return dirList;
    }

    private String formatFilePath(String path) {
        StringBuilder filePathBuilder = new StringBuilder(path);
        if (!path.endsWith("/")) {
            filePathBuilder.append("/");
        }
        return filePathBuilder.toString();
    }

    private String formatLocalFilePath(String path) {
        StringBuilder localFilePathBuilder = new StringBuilder();
        localFilePathBuilder.append(path.replace('\\', '/'));
        if (!localFilePathBuilder.toString().endsWith("/")) {
            localFilePathBuilder.append("/");
        }
        return localFilePathBuilder.toString();
    }

    private void createDirIfNotExist(String path) {
        String filePath = this.formatFilePath(path);
        ChannelSftp channelSftp = this.getChannelSftp();
        StringBuilder dirPath = new StringBuilder();
        for (String relativePath : filePath.split("/")) {
            if (StringUtils.isEmpty((CharSequence)relativePath)) continue;
            dirPath.append("/");
            dirPath.append(relativePath);
            try {
                channelSftp.cd(dirPath.toString());
            }
            catch (SftpException e) {
                if (2 == e.id) {
                    try {
                        channelSftp.mkdir(dirPath.toString());
                        continue;
                    }
                    catch (SftpException e1) {
                        throw new FileSystemException((Throwable)e1);
                    }
                }
                throw new FileSystemException((Throwable)e);
            }
        }
        try {
            channelSftp.cd(dirPath.toString());
        }
        catch (SftpException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private void createLocalDirIfNotExist(String path) {
        StringBuilder dirPath = new StringBuilder();
        for (String relativePath : path.split("/")) {
            if (StringUtils.isEmpty((CharSequence)relativePath)) continue;
            dirPath.append("/");
            dirPath.append(relativePath);
            File localDir = new File(dirPath.toString());
            if (localDir.exists() || localDir.mkdir()) continue;
            throw new FileSystemException("Create local dir exception: " + dirPath.toString());
        }
    }

    private boolean uploadFile(String localFileName, String remoteFileName) {
        File file = new File(localFileName);
        if (!file.exists()) {
            throw new FileSystemException("Local file does not exist:" + localFileName);
        }
        try (FileInputStream is = new FileInputStream(file);){
            this.getChannelSftp().put((InputStream)is, remoteFileName, 0);
        }
        catch (SftpException | IOException e) {
            throw new FileSystemException(e);
        }
        return true;
    }

    private boolean downloadFile(String localFileName, String remoteFileName) {
        if (!this.isFileExist(remoteFileName)) {
            throw new FileSystemException(String.format("Files to download:%s not found!", remoteFileName));
        }
        File localFile = new File(localFileName);
        if (localFile.exists() && !localFile.delete()) {
            throw new FileSystemException("Local file already exists, delete failed!");
        }
        try (InputStream is = this.getChannelSftp().get(remoteFileName);
             FileOutputStream os = new FileOutputStream(localFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (SftpException | IOException e) {
            throw new FileSystemException(e);
        }
        return true;
    }

    private boolean isRelative(String file) {
        if (file.startsWith("/")) {
            return false;
        }
        return file.length() <= 2 || file.charAt(1) != ':';
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }

    @Override
    public void disconnect() {
        try {
            if (Objects.nonNull(this.channelSftp) && this.channelSftp.isConnected()) {
                this.channelSftp.disconnect();
            }
            if (Objects.nonNull(this.session) && this.session.isConnected()) {
                this.session.disconnect();
            }
        }
        catch (Exception e) {
            logger.error("Sftp close connect failed!", (Throwable)e);
        }
    }

    @Override
    public boolean isConnected() {
        return Objects.nonNull(this.channelSftp) && this.channelSftp.isConnected() && Objects.nonNull(this.session) && this.session.isConnected();
    }
}

