/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.core;

import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.config.core.ChangeListener;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import cn.com.yusys.yusp.commons.config.exception.ConfigException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.springframework.util.StringUtils;

public abstract class AbstractConfigTemplate<S, T>
implements ConfigTemplate {
    protected Map<ChangeListener, T> listenerMap = new ConcurrentHashMap<ChangeListener, T>();

    protected boolean doRemoveListener(String dataId, ChangeListener changeListener, BiConsumer<String, T> consumer) {
        T listener = this.listenerMap.get(changeListener);
        if (listener != null) {
            consumer.accept(dataId, (String)listener);
            this.listenerMap.remove(changeListener);
            return true;
        }
        return false;
    }

    protected String parseExtension(String dataId) {
        String extension;
        int idx = dataId.lastIndexOf(".");
        if (idx > 0 && idx < dataId.length() - 1 && !StringUtils.isEmpty((Object)(extension = dataId.substring(idx + 1)))) {
            return extension.trim().toLowerCase();
        }
        throw new ConfigException("\u914d\u7f6e\u6587\u4ef6\u540d\u79f0\u5fc5\u987b\u5e26\u6709\u7c7b\u578b\u540e\u7f00\uff0c\u5982xxx.json");
    }

    protected abstract ChangeEvent transform(String var1, S var2, Set<String> var3);
}

