/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.annotation;

import cn.com.yusys.yusp.commons.config.annotation.ItemChangeListenerRegister;
import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MethodInvoker;

public class ChangeListenerAnnotationManager {
    private static final Logger log = LoggerFactory.getLogger(ChangeListenerAnnotationManager.class);
    private final ItemChangeListenerRegister itemChangeListenerRegister;
    private Map<String, List<MethodInvoker>> dataIdListeners = new HashMap<String, List<MethodInvoker>>();
    private final ConfigTemplate configTemplate;

    public ChangeListenerAnnotationManager(ItemChangeListenerRegister itemChangeListenerRegister, ConfigTemplate configTemplate) {
        this.itemChangeListenerRegister = itemChangeListenerRegister;
        this.configTemplate = configTemplate;
    }

    public void addListener(String dataId, String methodName, Object target, String ... interestedKeys) {
        if (interestedKeys.length == 0) {
            this.dataIdListeners.putIfAbsent(dataId, new ArrayList());
            List<MethodInvoker> invokers = this.dataIdListeners.get(dataId);
            invokers.add(this.buildMethodInvoker(methodName, target));
        }
        this.itemChangeListenerRegister.addListener(dataId, methodName, target, interestedKeys);
    }

    public void startListener() {
        this.dataIdListeners.forEach((dataId, invokers) -> this.configTemplate.addListener((String)dataId, event -> invokers.forEach(invoker -> this.invoke((MethodInvoker)invoker, event))));
        this.itemChangeListenerRegister.register(this.configTemplate);
    }

    private MethodInvoker buildMethodInvoker(String methodName, Object target) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(target);
        invoker.setTargetMethod(methodName);
        return invoker;
    }

    private void invoke(MethodInvoker invoker, ChangeEvent event) {
        try {
            invoker.setArguments(new Object[]{event});
            if (!invoker.isPrepared()) {
                invoker.prepare();
            }
            invoker.invoke();
        }
        catch (Exception e) {
            log.error("invoke exception", (Throwable)e);
        }
    }

    public String[] getListenerKeys() {
        return this.itemChangeListenerRegister.interestedKeys();
    }

    public String[] getListenersDataId() {
        return this.dataIdListeners.keySet().toArray(new String[0]);
    }
}

