/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.annotation;

import cn.com.yusys.yusp.commons.config.annotation.ChangeListener;
import cn.com.yusys.yusp.commons.config.annotation.ChangeListenerAnnotationManager;
import cn.com.yusys.yusp.commons.config.annotation.DataIdConverter;
import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ChangeListenerAnnotationBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(ChangeListenerAnnotationBeanPostProcessor.class);
    private Environment environment;
    private final ChangeListenerAnnotationManager manager;
    private final DataIdConverter dataIdConverter;
    private final Set<Class<? extends Annotation>> listenerAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(4);

    public ChangeListenerAnnotationBeanPostProcessor(ChangeListenerAnnotationManager manager, DataIdConverter dataIdConverter) {
        this.listenerAnnotationTypes.add(ChangeListener.class);
        this.manager = manager;
        this.dataIdConverter = dataIdConverter;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        this.buildAutowiringMetadata(bean.getClass(), bean);
        return pvs;
    }

    private void buildAutowiringMetadata(Class<?> clazz, Object bean) {
        ReflectionUtils.doWithLocalMethods(clazz, method -> {
            MergedAnnotation<?> ann = this.findAnnotation(method);
            if (ann != null) {
                if (Modifier.isStatic(method.getModifiers())) {
                    logger.info("ChangeListener annotation is not supported on static methods: {}", (Object)method);
                    return;
                }
                if (method.getParameterCount() != 1 || !method.getParameterTypes()[0].isAssignableFrom(ChangeEvent.class)) {
                    logger.warn("ConfigChangeListener annotation method should only be one parameter of ConfigChangeEvent: {}", (Object)method);
                    return;
                }
                this.parseAnnotation(ann, method.getName(), bean);
            }
        });
    }

    private MergedAnnotation<?> findAnnotation(AccessibleObject ao) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)ao);
        for (Class<? extends Annotation> type : this.listenerAnnotationTypes) {
            MergedAnnotation annotation = annotations.get(type);
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return null;
    }

    private void parseAnnotation(MergedAnnotation<?> ann, String methodName, Object bean) {
        AnnotationAttributes attributes = ann.asAnnotationAttributes(new MergedAnnotation.Adapt[0]);
        String dataId = attributes.getString("value");
        dataId = StringUtils.isEmpty((Object)dataId) ? attributes.getString("dataId") : dataId;
        if (StringUtils.isEmpty((Object)(dataId = this.environment.resolvePlaceholders(dataId)))) {
            String errorMessage = String.format("Bean:[%s], method:[%s] marked ChangeListener annotation must exist [dataId/value] property value!", bean.getClass().getName(), methodName);
            logger.error(errorMessage);
            throw new AnnotationConfigurationException(errorMessage);
        }
        Object[] interestedKeys = attributes.getStringArray("interestedKeys");
        if (!dataId.toLowerCase().endsWith(".properties") && ArrayUtils.nonEmpty((Object[])interestedKeys)) {
            logger.warn("dataId/value does not end with properties, interestedKeys property configuration is invalid!");
        }
        for (int i = 0; i < interestedKeys.length; ++i) {
            interestedKeys[i] = this.environment.resolvePlaceholders((String)interestedKeys[i]);
        }
        if (Objects.nonNull(this.dataIdConverter)) {
            dataId = (String)this.dataIdConverter.convert(dataId);
        }
        this.manager.addListener(dataId, methodName, bean, (String[])interestedKeys);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

