/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.kafka.config;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.AppenderAttachable;
import cn.com.yusys.yusp.commons.log.common.kafka.strategy.AsynchronousDeliveryStrategy;
import cn.com.yusys.yusp.commons.log.common.kafka.strategy.DeliveryStrategy;
import cn.com.yusys.yusp.commons.log.common.kafka.strategy.KeyingStrategy;
import cn.com.yusys.yusp.commons.log.common.kafka.strategy.NoKeyKeyingStrategy;
import java.util.HashMap;
import java.util.Map;

public abstract class KafkaAppenderConfig<E>
extends UnsynchronizedAppenderBase<E>
implements AppenderAttachable<E> {
    protected String topic = null;
    protected Encoder<E> encoder = null;
    protected KeyingStrategy<? super E> keyingStrategy = null;
    protected DeliveryStrategy deliveryStrategy;
    protected Integer partition = null;
    protected boolean appendTimestamp = true;
    protected Map<String, Object> producerConfig = new HashMap<String, Object>();

    protected boolean checkPrerequisites() {
        boolean errorFree = true;
        if (this.producerConfig.get("bootstrap.servers") == null) {
            this.addError(String.format("No \"%s\" set for the appender named [\"%s\"].", "bootstrap.servers", this.name));
            errorFree = false;
        }
        if (this.topic == null) {
            this.addError(String.format("No topic set for the appender named [\"%s\"].", this.name));
            errorFree = false;
        }
        if (this.encoder == null) {
            this.addError(String.format("No encoder set for the appender named [\"%s\"].", this.name));
            errorFree = false;
        }
        if (this.keyingStrategy == null) {
            this.addInfo(String.format("No explicit keyingStrategy set for the appender named [\"%s\"]. Using default NoKeyKeyingStrategy.", this.name));
            this.keyingStrategy = new NoKeyKeyingStrategy();
        }
        if (this.deliveryStrategy == null) {
            this.addInfo(String.format("No explicit deliveryStrategy set for the appender named [\"%s\"]. Using default asynchronous strategy.", this.name));
            this.deliveryStrategy = new AsynchronousDeliveryStrategy();
        }
        return errorFree;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setKeyingStrategy(KeyingStrategy<? super E> keyingStrategy) {
        this.keyingStrategy = keyingStrategy;
    }

    public void addProducerConfig(String keyValue) {
        String[] split = keyValue.split("=", 2);
        if (split.length == 2) {
            this.addProducerConfigValue(split[0], split[1]);
        }
    }

    public void addProducerConfigValue(String key, Object value) {
        this.producerConfig.put(key, value);
    }

    public Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    public void setDeliveryStrategy(DeliveryStrategy deliveryStrategy) {
        this.deliveryStrategy = deliveryStrategy;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public boolean isAppendTimestamp() {
        return this.appendTimestamp;
    }

    public void setAppendTimestamp(boolean appendTimestamp) {
        this.appendTimestamp = appendTimestamp;
    }
}

