/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.kafka.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import cn.com.yusys.yusp.commons.log.common.kafka.config.KafkaAppenderConfig;
import cn.com.yusys.yusp.commons.log.common.kafka.strategy.FailedDeliveryCallback;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaJsonAppender<E>
extends KafkaAppenderConfig<E> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaJsonAppender.class);
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String KAFKA_LOGGER_PREFIX = KafkaProducer.class.getPackage().getName().replaceFirst("\\.producer$", "");
    private static final Map<String, String> finalFields = new LinkedHashMap<String, String>();
    private String serviceName;
    private String port = "8080";
    private static String ip;
    private String ignoreCommonFields;
    private boolean noCommonFields = false;
    private String finalFieldsStr = "";
    private boolean ignoreTime = false;
    private LazyProducer lazyProducer = null;
    private final AppenderAttachableImpl<E> appenderAttachable = new AppenderAttachableImpl();
    private final ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue();
    private final FailedDeliveryCallback<E> failedDeliveryCallback = (evt, throwable) -> this.appenderAttachable.appendLoopOnAppenders(evt);

    public KafkaJsonAppender() {
        this.addProducerConfigValue("key.serializer", ByteArraySerializer.class.getName());
        this.addProducerConfigValue("value.serializer", ByteArraySerializer.class.getName());
    }

    public void doAppend(E e) {
        this.ensureDeferredAppends();
        if (e instanceof ILoggingEvent && ((ILoggingEvent)e).getLoggerName().startsWith(KAFKA_LOGGER_PREFIX)) {
            this.deferAppend(e);
        } else {
            super.doAppend(e);
        }
    }

    public void start() {
        this.processCommonFields();
        if (!this.checkPrerequisites()) {
            return;
        }
        if (this.partition != null && this.partition < 0) {
            this.partition = null;
        }
        this.lazyProducer = new LazyProducer();
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.lazyProducer != null && this.lazyProducer.isInitialized()) {
            try {
                this.lazyProducer.get().close();
            }
            catch (KafkaException e) {
                this.addWarn("Failed to shut down kafka producer: " + e.getMessage(), e);
            }
            this.lazyProducer = null;
        }
    }

    public void addAppender(Appender<E> newAppender) {
        this.appenderAttachable.addAppender(newAppender);
    }

    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.appenderAttachable.iteratorForAppenders();
    }

    public Appender<E> getAppender(String name) {
        return this.appenderAttachable.getAppender(name);
    }

    public boolean isAttached(Appender<E> appender) {
        return this.appenderAttachable.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.appenderAttachable.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<E> appender) {
        return this.appenderAttachable.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.appenderAttachable.detachAppender(name);
    }

    protected void append(E e) {
        byte[] payload = this.encoder.encode(e);
        byte[] key = this.keyingStrategy.createKey(e);
        byte[] newByte = null;
        try {
            String str = new String(payload, StandardCharsets.UTF_8.name());
            if (!StringUtils.isEmpty((CharSequence)str)) {
                String newStr = this.genJsonMsg(str);
                newByte = newStr.getBytes();
            }
        }
        catch (UnsupportedEncodingException e1) {
            newByte = payload;
            logger.warn(StringUtils.replaceObjNull(e));
        }
        Long timestamp = this.isAppendTimestamp() ? this.getTimestamp(e) : null;
        ProducerRecord record = new ProducerRecord(this.topic, this.partition, timestamp, (Object)key, (Object)newByte);
        Producer<byte[], byte[]> producer = this.lazyProducer.get();
        if (producer != null) {
            this.deliveryStrategy.send(this.lazyProducer.get(), record, e, this.failedDeliveryCallback);
        } else {
            this.failedDeliveryCallback.onFailedDelivery(e, null);
        }
    }

    private String genJsonMsg(String msg) {
        if (this.ignoreTime) {
            return "{" + this.finalFieldsStr + msg.substring(1);
        }
        return "{" + this.finalFieldsStr + "\"" + "logTimestamp" + "\":\"" + this.getCurrentTime() + "\"," + msg.substring(1);
    }

    private void processCommonFields() {
        if (!this.noCommonFields) {
            LinkedHashMap<String, String> finalFields = new LinkedHashMap<String, String>();
            finalFields.put("serviceName", this.serviceName);
            finalFields.put("ip", ip);
            finalFields.put("port", this.port);
            if (StringUtils.isEmpty((CharSequence)this.ignoreCommonFields)) {
                this.genFinalFieldsStr(finalFields);
            } else {
                String[] ignores;
                for (String str : ignores = this.ignoreCommonFields.split(",")) {
                    if ("logTimestamp".equals(str)) {
                        this.ignoreTime = true;
                    }
                    finalFields.remove(str);
                }
                if (finalFields.isEmpty()) {
                    this.noCommonFields = true;
                } else {
                    this.genFinalFieldsStr(finalFields);
                }
            }
        }
    }

    protected Long getTimestamp(E e) {
        if (e instanceof ILoggingEvent) {
            return ((ILoggingEvent)e).getTimeStamp();
        }
        return System.currentTimeMillis();
    }

    private void genFinalFieldsStr(Map<String, String> finalFields) {
        for (Map.Entry<String, String> entry : finalFields.entrySet()) {
            this.finalFieldsStr = String.format("%s\"%s\":\"%s\",", this.finalFieldsStr, entry.getKey(), entry.getValue());
        }
    }

    private String getCurrentTime() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(LOG_TIMESTAMP_FORMAT);
        return dtf.format(LocalDateTime.now());
    }

    protected Producer<byte[], byte[]> createProducer() {
        return new KafkaProducer(new HashMap(this.producerConfig));
    }

    private void deferAppend(E event) {
        this.queue.add(event);
    }

    private void ensureDeferredAppends() {
        E event;
        while ((event = this.queue.poll()) != null) {
            super.doAppend(event);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getIgnoreCommonFields() {
        return this.ignoreCommonFields;
    }

    public boolean isNoCommonFields() {
        return this.noCommonFields;
    }

    public String getFinalFieldsStr() {
        return this.finalFieldsStr;
    }

    public boolean isIgnoreTime() {
        return this.ignoreTime;
    }

    public void setIgnoreCommonFields(String ignoreCommonFields) {
        this.ignoreCommonFields = ignoreCommonFields;
    }

    public void setNoCommonFields(boolean noCommonFields) {
        this.noCommonFields = noCommonFields;
    }

    public void setFinalFieldsStr(String finalFieldsStr) {
        this.finalFieldsStr = finalFieldsStr;
    }

    public void setIgnoreTime(boolean ignoreTime) {
        this.ignoreTime = ignoreTime;
    }

    public static Map<String, String> getFinalFields() {
        return finalFields;
    }

    public String getPort() {
        return this.port;
    }

    public String getIp() {
        return ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setIp(String ip) {
        KafkaJsonAppender.ip = ip;
    }

    static {
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("", (Throwable)e);
        }
    }

    private class LazyProducer {
        private volatile Producer<byte[], byte[]> producer;

        private LazyProducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Producer<byte[], byte[]> get() {
            Producer<byte[], byte[]> result = this.producer;
            if (result == null) {
                LazyProducer lazyProducer = this;
                synchronized (lazyProducer) {
                    result = this.producer;
                    if (result == null) {
                        this.producer = result = this.initialize();
                    }
                }
            }
            return result;
        }

        protected Producer<byte[], byte[]> initialize() {
            Producer<byte[], byte[]> producer = null;
            try {
                producer = KafkaJsonAppender.this.createProducer();
            }
            catch (Exception e) {
                KafkaJsonAppender.this.addError("error creating producer", e);
            }
            return producer;
        }

        public boolean isInitialized() {
            return this.producer != null;
        }
    }
}

