/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.constant;

import cn.com.yusys.yusp.commons.log.common.constant.MargicNumberConstant;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public abstract class CommonEnum<T extends CommonEnum>
implements Comparable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CommonEnum.class);
    private static final long serialVersionUID = -3452282958188035040L;
    private static final Map<String, CommonEnum> EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static Map<Class<CommonEnum>, Entry> cEnumClasses = new WeakHashMap<Class<CommonEnum>, Entry>();
    private String name;
    private String cname;
    private Number value;
    private String desc;
    private static final String CAN_NOT_BE_NULL = "The Enum Class must not be null";
    private static final String MUST_BE_SUBCLASS = "The Class must be a subclass of Enum";

    public static CommonEnum create() {
        return CommonEnum.create(null, null, null, null);
    }

    public static CommonEnum create(String name) {
        return CommonEnum.create(name, null, null, null);
    }

    public static CommonEnum create(String name, Number value) {
        return CommonEnum.create(name, value, null, null);
    }

    public static CommonEnum create(Number value, String cname) {
        return CommonEnum.create(null, value, cname, null);
    }

    public static CommonEnum create(String name, Number value, String cname) {
        return CommonEnum.create(name, value, cname, null);
    }

    public static CommonEnum create(String name, Number value, String cname, String desc) {
        CommonEnum menum = CommonEnum.init(name);
        Objects.requireNonNull(menum, "CommonEnum must not null!");
        if (StringUtils.nonEmpty((CharSequence)name)) {
            menum.name = name;
        }
        menum.cname = cname;
        menum.value = value;
        menum.desc = desc;
        return menum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommonEnum init(String name) {
        try {
            Class enumClass = ClassUtils.resolveClassName((String)CommonEnum.getCallerClassName(), (ClassLoader)Thread.currentThread().getContextClassLoader());
            Class<CommonEnum> clazz = CommonEnum.class;
            synchronized (CommonEnum.class) {
                Entry entry = cEnumClasses.get(enumClass);
                if (entry == null) {
                    entry = CommonEnum.createEntry(enumClass);
                    WeakHashMap<Class<CommonEnum>, Entry> myMap = new WeakHashMap<Class<CommonEnum>, Entry>(cEnumClasses);
                    myMap.put(enumClass, entry);
                    cEnumClasses = myMap;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                CommonEnum enumObject = (CommonEnum)enumClass.newInstance();
                if (StringUtils.nonEmpty((CharSequence)name)) {
                    if (!entry.map.containsKey(name)) {
                        enumObject.name = name;
                        entry.map.put(name, enumObject);
                    } else {
                        throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
                    }
                }
                entry.list.add(enumObject);
                return enumObject;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static String getCallerClassName() {
        StackTraceElement[] callers = new Throwable().getStackTrace();
        String enumClass = CommonEnum.class.getName();
        for (StackTraceElement caller : callers) {
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            if (enumClass.equals(className) || !"<clinit>".equals(methodName)) continue;
            return className;
        }
        throw new IllegalArgumentException("");
    }

    protected Object readResolve() {
        Entry entry = cEnumClasses.get(this.getEnumClass());
        if (entry == null) {
            return null;
        }
        return entry.map.get(this.name());
    }

    private Class getEnumClass() {
        return this.getClass();
    }

    private static <T> Entry getEntry(Class<T> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException(CAN_NOT_BE_NULL);
        }
        if (!CommonEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MUST_BE_SUBCLASS);
        }
        Entry entry = cEnumClasses.get(enumClass);
        if (entry == null) {
            try {
                Class.forName(enumClass.getName(), true, enumClass.getClassLoader());
                entry = cEnumClasses.get(enumClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entry;
    }

    private static Entry createEntry(Class enumClass) {
        Entry entry = new Entry();
        for (Class cls = enumClass.getSuperclass(); cls != null && cls != CommonEnum.class; cls = cls.getSuperclass()) {
            Entry loopEntry = cEnumClasses.get(cls);
            if (loopEntry == null) continue;
            entry.list.addAll(loopEntry.list);
            entry.map.putAll(loopEntry.map);
            break;
        }
        return entry;
    }

    public static <T> CommonEnum getEnum(Class<T> enumClass, String name) {
        Entry entry = CommonEnum.getEntry(enumClass);
        if (entry == null) {
            return null;
        }
        return entry.map.get(name);
    }

    public static <T> CommonEnum getEnum(Class<T> enumClass, Number value) {
        if (enumClass == null) {
            throw new IllegalArgumentException(CAN_NOT_BE_NULL);
        }
        List list = CommonEnum.getEnumList(enumClass);
        for (CommonEnum enumeration : list) {
            if (enumeration.value() != value.intValue()) continue;
            return enumeration;
        }
        return null;
    }

    public static <T> CommonEnum getEnumByCnName(Class<T> enumClass, String cnName) {
        if (enumClass == null) {
            throw new IllegalArgumentException(CAN_NOT_BE_NULL);
        }
        List list = CommonEnum.getEnumList(enumClass);
        for (CommonEnum enumeration : list) {
            if (!enumeration.cname.equalsIgnoreCase(cnName)) continue;
            return enumeration;
        }
        return null;
    }

    public static <T> Map<String, CommonEnum> getEnumMap(Class<T> enumClass) {
        Entry entry = CommonEnum.getEntry(enumClass);
        if (entry == null) {
            return EMPTY_MAP;
        }
        return entry.unmodifiableMap;
    }

    public static <T> List getEnumList(Class<T> enumClass) {
        Entry entry = CommonEnum.getEntry(enumClass);
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return entry.unmodifiableList;
    }

    protected static Iterator<CommonEnum> iterator(Class<CommonEnum> enumClass) {
        return CommonEnum.getEnumList(enumClass).iterator();
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.name.equals(((CommonEnum)other).name);
        }
        return Objects.equals(other.getClass(), this.getClass());
    }

    public int compareTo(Object other) {
        if (other.equals(this)) {
            return 0;
        }
        if (other.getClass() != this.getClass()) {
            throw new ClassCastException("Different enum class '" + ClassUtils.getShortName(other.getClass()) + "'");
        }
        return this.name.compareTo(((CommonEnum)other).name);
    }

    public boolean isIn(Class<T> enumClass, int value) {
        if (enumClass == null) {
            throw new IllegalArgumentException(CAN_NOT_BE_NULL);
        }
        List list = CommonEnum.getEnumList(enumClass);
        for (CommonEnum enumeration : list) {
            if (enumeration.getValue().intValue() != value) continue;
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    public final int value() {
        return this.value.intValue();
    }

    public final byte byteValue() {
        return this.value.byteValue();
    }

    public final short shortValue() {
        return this.value.shortValue();
    }

    public final long longValue() {
        return this.value.longValue();
    }

    public final String name() {
        if (this.name == null) {
            Class enumClass = this.getEnumClass();
            Entry entry = cEnumClasses.get(this.getEnumClass());
            entry.populateNames(enumClass);
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Number getValue() {
        return this.value;
    }

    public String getCname() {
        return this.cname;
    }

    public String getDesc() {
        return this.desc;
    }

    private static class Entry {
        final Map<String, CommonEnum> map = new HashMap<String, CommonEnum>();
        final Map<String, CommonEnum> unmodifiableMap = Collections.unmodifiableMap(this.map);
        final List<CommonEnum> list = new ArrayList<CommonEnum>(MargicNumberConstant.n25);
        final List<CommonEnum> unmodifiableList = Collections.unmodifiableList(this.list);

        protected Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void populateNames(Class enumClass) {
            String string = enumClass.getName().intern();
            synchronized (string) {
                Field[] fields;
                block5: for (Field field : fields = enumClass.getFields()) {
                    int modifier = field.getModifiers();
                    if (!Modifier.isPublic(modifier) || !Modifier.isFinal(modifier) || !Modifier.isStatic(modifier)) continue;
                    try {
                        Object value = field.get(null);
                        String fname = field.getName();
                        for (CommonEnum enumObject : this.unmodifiableList) {
                            if (value == null || !value.equals(enumObject) || enumObject.name != null || this.unmodifiableMap.containsKey(fname)) continue;
                            enumObject.name = fname;
                            this.map.put(fname, enumObject);
                            continue block5;
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
    }
}

