/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.extension;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.collection.KeyValue;
import cn.com.yusys.yusp.commons.util.collection.MapUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.reflection.ParamNameUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSessionTemplateExtension
extends SqlSessionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(SqlSessionTemplateExtension.class);
    private static final Map<String, String> BATCH_ACTUAL_PARAMETER_NAME = new ConcurrentHashMap<String, String>();
    private final int batchFlushSize;
    private final Configuration configuration;
    private final boolean useActualParamName;

    public SqlSessionTemplateExtension(SqlSessionFactory sqlSessionFactory, int batchFlushSize) {
        this(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType(), batchFlushSize);
    }

    public SqlSessionTemplateExtension(SqlSessionFactory sqlSessionFactory, ExecutorType executorType, int batchFlushSize) {
        super(sqlSessionFactory, executorType);
        this.batchFlushSize = batchFlushSize;
        this.configuration = sqlSessionFactory.getConfiguration();
        this.useActualParamName = this.configuration.isUseActualParamName();
    }

    private boolean isBatchOperation(String statement) {
        return statement.endsWith("InBatch");
    }

    public int insert(String statement, Object parameter) {
        return this.isBatchOperation(statement) ? this.batchInsert(statement, parameter) : super.insert(statement, parameter);
    }

    private int batchInsert(String statement, Object parameters) {
        return this.batch(statement, parameters, (session, parameter) -> session.insert(statement, parameter));
    }

    private int batch(String statement, Object parameters, BiFunction<SqlSession, Object, Integer> sqlSessionFunction) {
        int i = 0;
        int count = 1;
        try (SqlSession session = this.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);){
            List<?> listParameters = this.getBatchListParameters(statement, parameters);
            if (CollectionUtils.isEmpty(listParameters)) {
                throw new IllegalArgumentException(" The input parameter of batch insert is incorrect, only one list type parameter is supported!");
            }
            for (Object parameter : listParameters) {
                sqlSessionFunction.apply(session, parameter);
                if (count == this.batchFlushSize) {
                    session.flushStatements();
                    session.clearCache();
                    count = 0;
                }
                ++count;
                ++i;
            }
            session.commit();
        }
        return i;
    }

    public int update(String statement, Object parameter) {
        return this.isBatchOperation(statement) ? this.batchUpdate(statement, parameter) : super.update(statement, parameter);
    }

    private int batchUpdate(String statement, Object parameters) {
        return this.batch(statement, parameters, (session, parameter) -> session.update(statement, parameter));
    }

    public int delete(String statement, Object parameter) {
        return this.isBatchOperation(statement) ? this.batchDelete(statement, parameter) : super.delete(statement, parameter);
    }

    private int batchDelete(String statement, Object parameters) {
        return this.batch(statement, parameters, (session, parameter) -> session.delete(statement, parameter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getActualParameter(String statement) {
        if (!BATCH_ACTUAL_PARAMETER_NAME.containsKey(statement)) {
            Map<String, String> map = BATCH_ACTUAL_PARAMETER_NAME;
            synchronized (map) {
                String actualParameter = this.getActualParameter0(statement);
                BATCH_ACTUAL_PARAMETER_NAME.put(statement, Objects.isNull(actualParameter) ? "" : actualParameter);
            }
        }
        return BATCH_ACTUAL_PARAMETER_NAME.get(statement);
    }

    private String getActualParameter0(String statement) {
        try {
            if (statement.contains(".")) {
                int lastIndexPoint = statement.lastIndexOf(".");
                String clazz = statement.substring(0, lastIndexPoint);
                String methodName = statement.substring(lastIndexPoint + 1);
                Method method = Arrays.stream(Class.forName(clazz).getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElse(null);
                if (method != null) {
                    Annotation[][] paramAnnotations = method.getParameterAnnotations();
                    String paramName = null;
                    if (paramAnnotations.length == 1) {
                        for (Annotation annotation : paramAnnotations[0]) {
                            if (!(annotation instanceof Param)) continue;
                            paramName = ((Param)annotation).value();
                            break;
                        }
                        if (paramName == null) {
                            if (this.useActualParamName) {
                                paramName = (String)ParamNameUtil.getParamNames((Method)method).get(0);
                            }
                            if (paramName == null) {
                                paramName = String.valueOf(0);
                            }
                        }
                    }
                    return paramName;
                }
            }
        }
        catch (Exception e) {
            logger.error("SqlId[{}] get actual parameter occur exception! cause by:{}", (Object)statement, (Object)e.getMessage());
        }
        return null;
    }

    private List<?> getBatchListParameters(String statement, Object parameters) {
        String actualParameter;
        if (parameters instanceof Map && StringUtils.nonEmpty((CharSequence)(actualParameter = this.getActualParameter(statement)))) {
            Object parameter = ((Map)parameters).get(actualParameter);
            return parameter instanceof List ? (List)parameter : Collections.singletonList(parameter);
        }
        return null;
    }

    private Object wrapParameter(String statement, Object parameter) {
        return MapUtils.ofHashMap((KeyValue[])new KeyValue[]{MapUtils.ofEntry((Object)BATCH_ACTUAL_PARAMETER_NAME.get(statement), (Object)parameter)});
    }
}

