/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.ClassUtils;

public class PropertiesUtils {
    private static Map<Class<?>, List<?>> cacheConfig = new ConcurrentHashMap(64);
    private static ObjectMapper objectMapper = new ObjectMapper();

    private PropertiesUtils() {
    }

    public static <T> List<T> loadProperties(String resourceLocation, Class<T> configClass, ClassLoader classLoader) {
        List<?> result = cacheConfig.get(configClass);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (result != null) {
            return result;
        }
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(resourceLocation) : ClassLoader.getSystemResources(resourceLocation);
            result = new ArrayList();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                UrlResource resource = new UrlResource(url);
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                result.add(objectMapper.convertValue((Object)properties, configClass));
            }
            cacheConfig.put(configClass, result);
            return result;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load factories from location [" + resourceLocation + "]", ex);
        }
    }

    public static synchronized <T> List<T> loadProperties(String resourceLocation, Class<T> configClass) {
        LinkedList<Object> list = new LinkedList<Object>();
        try {
            Enumeration<URL> urls = ClassUtils.getDefaultClassLoader().getResources(resourceLocation);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                UrlResource resource = new UrlResource(url);
                ResourcePropertySource propertySource = new ResourcePropertySource(url.toString(), new EncodedResource((Resource)resource, StandardCharsets.UTF_8));
                Binder binder = new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource((Map)propertySource.getSource())});
                BindResult bindResult = binder.bind("", configClass);
                if (!bindResult.isBound()) continue;
                list.add(bindResult.get());
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load factories from location [" + resourceLocation + "]", ex);
        }
        return list;
    }

    public static Map<String, Object> getPropertiesInfo(String fileName) {
        try {
            Enumeration<URL> urls = ClassUtils.getDefaultClassLoader().getResources(fileName);
            if (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                UrlResource resource = new UrlResource(url);
                ResourcePropertySource propertySource = new ResourcePropertySource(url.toString(), new EncodedResource((Resource)resource, StandardCharsets.UTF_8));
                return (Map)propertySource.getSource();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load factories from location [" + fileName + "]", e);
        }
        return null;
    }
}

