/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.listener;

import cn.com.yusys.yusp.commons.module.AbstractSpringApplicationEventListener;
import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleHelper;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.core.Ordered;

public class ApplicationModulePrintEventListener
extends AbstractSpringApplicationEventListener<ApplicationContextInitializedEvent>
implements Ordered {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
    private static AtomicInteger intAdder = new AtomicInteger(0);

    @Override
    public void executeEvent(ApplicationContextInitializedEvent event) {
        List<Module> modules = ModuleHelper.modules();
        StringBuilder builder = new StringBuilder("--------------------------------------\n");
        modules.forEach(module -> builder.append(this.getModuleInfo((Module)module)).append("\n"));
        builder.append("--------------------------------------\n");
        this.modulePrint(builder.toString());
    }

    private String getModuleInfo(Module module) {
        return StringUtils.buffer0((Object[])new Object[]{"\u7ec4\u4ef6:", StringUtils.replaceAll((String)module.getName(), (String)"yusp-commons-", (String)""), "(", module.getDesc(), "), ", module.getVersion()});
    }

    private void modulePrint(String printInfo) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
        logger.setUseParentHandlers(false);
        if (CommonUtils.isNullOrEmpty((Object[])logger.getHandlers())) {
            logger.addHandler(consoleHandler);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("The components currently in use are:%n%s", printInfo));
        }
    }

    @Override
    protected AtomicInteger getIntAdder() {
        return intAdder;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

