/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.config;

import cn.com.yusys.yusp.commons.module.domain.DomainHelper;
import cn.com.yusys.yusp.commons.module.start.AppMessagesService;
import cn.com.yusys.yusp.commons.module.start.BootStartMessagesService;
import cn.com.yusys.yusp.commons.module.start.EurekaStartMessagesService;
import cn.com.yusys.yusp.commons.module.start.NacosStartMessagesService;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModuleAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.context.refresh.ContextRefresher", "com.netflix.appinfo.EurekaInstanceConfig"})
    public AppMessagesService cloudStartMessagesService() {
        return new EurekaStartMessagesService();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.context.refresh.ContextRefresher", "com.alibaba.nacos.api.naming.pojo.Instance"})
    @ConditionalOnBean(name={"com.alibaba.nacos.api.naming.pojo.Instance"})
    public AppMessagesService nacosStartMessageService() {
        return new NacosStartMessagesService();
    }

    @Bean
    @ConditionalOnMissingBean
    public AppMessagesService bootStartMessagesService() {
        return new BootStartMessagesService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DomainHelper domainHelper() {
        return new DomainHelper();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextUtils springContextUtils() {
        return new SpringContextUtils();
    }
}

