/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public abstract class AbstractSpringApplicationEventListener<E extends SpringApplicationEvent>
implements ApplicationListener<E> {
    private final AtomicInteger intAdder = new AtomicInteger(0);
    private static final String bootstrap = "org.springframework.cloud.bootstrap.BootstrapApplicationListener";

    public abstract void executeEvent(E var1);

    public void onApplicationEvent(E event) {
        if (AbstractSpringApplicationEventListener.isBootStrap(event) && this.getIntAdder().get() == 0) {
            this.getIntAdder().incrementAndGet();
            return;
        }
        if (this.getIntAdder().get() == 1) {
            this.executeEvent(event);
            this.getIntAdder().incrementAndGet();
        }
    }

    protected static final boolean isBootStrap(SpringApplicationEvent event) {
        return ClassUtils.isPresent((String)bootstrap, null) && AbstractSpringApplicationEventListener.isCloudBootstrap(event);
    }

    private static final boolean isCloudBootstrap(SpringApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            return AbstractSpringApplicationEventListener.isCloudBootstrap((Environment)((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment());
        }
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            return AbstractSpringApplicationEventListener.isCloudBootstrap((Environment)((ApplicationEnvironmentPreparedEvent)event).getEnvironment());
        }
        if (event instanceof ApplicationFailedEvent) {
            return AbstractSpringApplicationEventListener.isCloudBootstrap((Environment)((ApplicationFailedEvent)event).getApplicationContext().getEnvironment());
        }
        if (event instanceof ApplicationPreparedEvent) {
            return AbstractSpringApplicationEventListener.isCloudBootstrap((Environment)((ApplicationPreparedEvent)event).getApplicationContext().getEnvironment());
        }
        if (event instanceof ApplicationReadyEvent) {
            return AbstractSpringApplicationEventListener.isCloudBootstrap((Environment)((ApplicationReadyEvent)event).getApplicationContext().getEnvironment());
        }
        if (event instanceof ApplicationStartedEvent) {
            return AbstractSpringApplicationEventListener.isCloudBootstrap((Environment)((ApplicationStartedEvent)event).getApplicationContext().getEnvironment());
        }
        if (event instanceof ApplicationStartingEvent) {
            return false;
        }
        return false;
    }

    private static final boolean isCloudBootstrap(Environment env) {
        return (Boolean)env.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)true);
    }

    protected AtomicInteger getIntAdder() {
        return this.intAdder;
    }
}

