/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log;

import cn.com.yusys.yusp.commons.log.ApiData;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.exception.ExceptionUtils;
import java.lang.reflect.Method;

public interface ApiLogHelper {
    default public Object logInvoke(String path, Object target, Method method, Object[] args) throws Throwable {
        return this.logInvoke(path, target, method, args, false);
    }

    default public Object logInvoke(String path, Object target, Method method, Object[] args, boolean report) throws Throwable {
        return this.logInvoke(path, method.getName(), () -> method.invoke(target, args), args, report);
    }

    default public void logInvoke(String path, String method, Task task, Object[] args, boolean report) throws Throwable {
        String message = "\u6210\u529f";
        ApiData apiData = this.before();
        apiData.setReport(report);
        apiData.setMethod(method);
        try {
            task.run();
        }
        catch (Throwable e) {
            apiData.setStatus(false);
            message = "\u5f02\u5e38:" + e.getMessage();
            throw ExceptionUtils.wrapReflectionException((Throwable)e);
        }
        finally {
            this.afterComplete(apiData, path, args, null, message);
        }
    }

    default public <T> T logInvoke(String path, String method, TaskSupplier<T> task, Object[] args, boolean report) throws Throwable {
        T result = null;
        String message = "\u6210\u529f";
        ApiData apiData = this.before();
        apiData.setReport(report);
        apiData.setMethod(method);
        try {
            T t = result = (T)task.run();
            return t;
        }
        catch (Throwable e) {
            apiData.setStatus(false);
            message = "\u5f02\u5e38:" + e.getMessage();
            throw ExceptionUtils.wrapReflectionException((Throwable)e);
        }
        finally {
            this.afterComplete(apiData, path, args, result, message);
        }
    }

    public ApiData before();

    default public void afterComplete(ApiData apiData, String path, Object[] args, Object result, String execStatus) {
        apiData.setArgs(args);
        apiData.setResult(result);
        apiData.setEndTime(System.currentTimeMillis());
        apiData.setExecStatus(execStatus);
        apiData.setPath(path);
        apiData.setFullPath(path);
        apiData.setContentLength(Double.valueOf(CommonUtils.calcObjectSize((Object)args)));
        this.afterComplete(apiData);
    }

    public void afterComplete(ApiData var1);

    @FunctionalInterface
    public static interface TaskSupplier<T> {
        public T run() throws Throwable;
    }

    @FunctionalInterface
    public static interface Task {
        public void run() throws Throwable;
    }
}

