/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.filter.compatible;

import cn.com.yusys.yusp.commons.session.compatible.UserService;
import cn.com.yusys.yusp.commons.session.compatible.dto.Contr;
import cn.com.yusys.yusp.commons.session.compatible.dto.MenuContr;
import cn.com.yusys.yusp.commons.session.util.SecurityUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

@Deprecated
public class CompatibilityAccessFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CompatibilityAccessFilter.class);
    public static final String IGNORE_URL_KEY = "IgnoreUrlKey";
    public static final String IGNORE_RESOURCE_KEY = "IgnoreResourceKey";
    public static final String ENABLED_SERVICE_FILTER_KEY = "EnabledServiceFilterKey";
    private static final int MAX_REFRESH_TIME = 60000;
    private List<? extends Contr> needAuthUrls;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    private UserService userCacheService;
    private boolean enableServiceFilter;
    private List<String> ignoreUrls;
    private List<String> ignoreResources;
    private long lastRefresh = System.currentTimeMillis();

    public CompatibilityAccessFilter(UserService userCacheService) {
        this.userCacheService = userCacheService;
    }

    public void init(FilterConfig filterConfig) {
        log.info("Create access permission interceptor!");
        Function<String, List> function = str -> Arrays.stream(str.split(",")).filter(StringUtils::nonEmpty).map(String::trim).collect(Collectors.toList());
        this.ignoreUrls = Optional.ofNullable(filterConfig.getInitParameter(IGNORE_URL_KEY)).map(function).orElse(Collections.emptyList());
        this.ignoreResources = Optional.ofNullable(filterConfig.getInitParameter(IGNORE_RESOURCE_KEY)).map(function).orElse(Collections.emptyList());
        this.enableServiceFilter = Optional.ofNullable(filterConfig.getInitParameter(ENABLED_SERVICE_FILTER_KEY)).map(Boolean::parseBoolean).orElse(false);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String appName;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean doAuthFilter = true;
        if (this.enableServiceFilter && StringUtils.nonBlank((CharSequence)(appName = request.getHeader("appName")))) {
            doAuthFilter = false;
        }
        if (doAuthFilter) {
            String requestUri = this.pathHelper.getLookupPathForRequest(request);
            String accessToken = SecurityUtils.getCurrentUserToken();
            if (log.isDebugEnabled()) {
                log.debug("CompatibilityAccessFilter enter utl:[{}] , ip:[{}:{}]", new Object[]{requestUri, servletRequest.getRemoteAddr(), servletRequest.getRemotePort()});
            }
            boolean isAuthorized = false;
            if (null != this.ignoreUrls) {
                isAuthorized = this.ignoreUrls.stream().anyMatch(ctrl -> this.matcher.matchStart(ctrl, requestUri));
            }
            if (!isAuthorized && null != this.ignoreResources) {
                isAuthorized = this.ignoreResources.stream().anyMatch(requestUri::endsWith);
            }
            try {
                if (!isAuthorized) {
                    if (null == accessToken) {
                        log.error("User information not obtained in request [{}], request not authorized", (Object)requestUri);
                    } else {
                        String loginCode = this.userCacheService.getUserCode(accessToken);
                        if (log.isDebugEnabled()) {
                            log.debug("loginCode:[{}];token:[{}]", (Object)loginCode, (Object)accessToken);
                        }
                        if (!StringUtils.isEmpty((CharSequence)loginCode)) {
                            if (this.needAuthUrls == null || System.currentTimeMillis() - this.lastRefresh > 60000L) {
                                this.needAuthUrls = this.userCacheService.findAllContrUrl(accessToken);
                                this.lastRefresh = System.currentTimeMillis();
                            }
                            if (null != this.needAuthUrls && !this.needAuthUrls.isEmpty()) {
                                boolean requestUriNeedAuth = this.needAuthUrls.stream().anyMatch(ctrl -> this.matcher.match(ctrl.getContrUrl(), requestUri));
                                if (requestUriNeedAuth) {
                                    MenuContr menucontr = this.userCacheService.getMenuandContr(loginCode, null, accessToken);
                                    List contrList = menucontr.getContr();
                                    if (contrList != null && contrList.size() > 0) {
                                        isAuthorized = contrList.stream().anyMatch(ctrl -> Objects.nonNull(ctrl.getContrUrl()) && this.matcher.match(ctrl.getContrUrl(), requestUri));
                                    }
                                } else {
                                    isAuthorized = true;
                                }
                            } else {
                                isAuthorized = true;
                            }
                        }
                    }
                }
                if (!isAuthorized) {
                    response.sendError(403, "user forbidden from yusp access filter");
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                log.error("CompatibilityAccessFilter exception:[{}]", (Object)e.getMessage());
                throw e;
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

