/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.fastdfs.service;

import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileInfo;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFolderInfo;
import cn.com.yusys.yusp.commons.file.client.fastdfs.StorageClientExt;
import cn.com.yusys.yusp.commons.file.client.fastdfs.mapper.FileFolderInfoMapper;
import cn.com.yusys.yusp.commons.file.client.fastdfs.mapper.FileInfoMapper;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.IdUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class FastDfsCommandService {
    private static final Logger logger = LoggerFactory.getLogger(FastDfsCommandService.class);
    private FileFolderInfoMapper fileFolderInfoMapper;
    private FileInfoMapper fileInfoMapper;
    private static Map<String, FastDfsFolderInfo> serverFolderPathCache = new ConcurrentHashMap<String, FastDfsFolderInfo>();
    private int maxFolderInfoCacheSize = 200;

    public FastDfsCommandService(FileFolderInfoMapper fileFolderInfoMapper, FileInfoMapper fileInfoMapper) {
        this.fileFolderInfoMapper = fileFolderInfoMapper;
        this.fileInfoMapper = fileInfoMapper;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void checkFolderAndFileInfoToDB(String serverId, String rootPath, FastDfsFileInfo info) throws IOException {
        FastDfsFolderInfo fastDfsFolderInfo = this.checkFileFolderInfoBottomUp(serverId, rootPath, info.getFilePath(), true);
        if (fastDfsFolderInfo == null) {
            logger.error("FastDfs Error Msg: folder not exists: {},{}, need delete fdfs file: {},{}", new Object[]{info.getServerId(), info.getFilePath(), info.getFileGroup(), info.getFileId()});
            throw new IOException("folder not exists: " + info.getFilePath());
        }
        info.setFolderId(fastDfsFolderInfo.getFolderId());
        this.fileInfoMapper.insertFileInfo(info);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void checkFolderAndMoveFileInDB(String serverId, String rootPath, String targetFileName, String targetPath, FastDfsFileInfo fastdfsInfo) {
        String relativePath = this.concatRelativePath(rootPath, targetPath);
        FastDfsFolderInfo fastdfsFolderInfo = this.checkFileFolderInfoBottomUp(serverId, rootPath, relativePath, true);
        fastdfsInfo.setFileName(targetFileName);
        fastdfsInfo.setExtName(StorageClientExt.getFileExtendName(targetFileName));
        fastdfsInfo.setFilePath(relativePath);
        fastdfsInfo.setFolderId(fastdfsFolderInfo.getFolderId());
        this.fileInfoMapper.updateFileInfo(fastdfsInfo);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean updateFileInfo(FastDfsFileInfo fastdfsInfo) {
        int updateFileInfo = this.fileInfoMapper.updateFileInfo(fastdfsInfo);
        return updateFileInfo > 0;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void checkFolderAndCopyFileInDB(String serverId, String rootPath, String targetFileName, String targetPath, FastDfsFileInfo fastdfsInfo) {
        String relativePath = this.concatRelativePath(rootPath, targetPath);
        this.checkFileFolderInfoBottomUp(serverId, rootPath, relativePath, true);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
        paramsMap.put("serverId", serverId);
        paramsMap.put("folderPath", relativePath);
        FastDfsFolderInfo fastDfsFolderInfo = this.fileFolderInfoMapper.selectFolderByPath(paramsMap);
        fastdfsInfo.setFileSeq(IdUtils.nextId());
        fastdfsInfo.setFileName(targetFileName);
        fastdfsInfo.setExtName(StorageClientExt.getFileExtendName(targetFileName));
        fastdfsInfo.setFilePath(this.concatRelativePath(rootPath, targetPath));
        fastdfsInfo.setFolderId(fastDfsFolderInfo.getFolderId());
        fastdfsInfo.setUploadDate(new Date());
        this.fileInfoMapper.insertFileInfo(fastdfsInfo);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public FastDfsFolderInfo checkFileFolderInfoBottomUp(String serverId, String rootPath, String remoteFilePath, boolean addFolderVersionFlag) {
        FastDfsFolderInfo folderInfo;
        String folderPath;
        block8: {
            folderPath = this.removeFolderTailSeparatorIfExists(remoteFilePath);
            String parentFolderPath = this.getParentFolderPath(folderPath);
            String key = serverId.concat(":").concat(folderPath);
            folderInfo = null;
            try {
                folderInfo = new FastDfsFolderInfo();
                long folderId = IdUtils.nextId();
                folderInfo.setFolderId(folderId);
                folderInfo.setParentFolderPath(parentFolderPath);
                folderInfo.setServerId(serverId);
                Object[] arr = (String[])Arrays.stream(folderPath.split("/")).filter(StringUtils::nonBlank).toArray(String[]::new);
                folderInfo.setFolderPath(folderPath);
                folderInfo.setFolderLevel(arr.length);
                folderInfo.setVersion(1);
                if (arr.length >= 4) {
                    folderInfo.setLevel4FolderPath("/" + StringUtils.join((Object[])arr, (String)"/", (int)0, (int)4));
                }
                if (arr.length >= 3) {
                    folderInfo.setLevel3FolderPath("/" + StringUtils.join((Object[])arr, (String)"/", (int)0, (int)3));
                }
                if (arr.length >= 2) {
                    folderInfo.setLevel2FolderPath("/" + StringUtils.join((Object[])arr, (String)"/", (int)0, (int)2));
                }
                folderInfo.setLastUpdateTime(new Date());
                this.fileFolderInfoMapper.insertFileFolderInfo(folderInfo);
                if (addFolderVersionFlag && !StringUtils.isBlank((CharSequence)parentFolderPath)) {
                    this.addFolderVersion(serverId, rootPath, parentFolderPath, new Date());
                }
                this.putFolderInfoIntoCache(key, folderInfo);
            }
            catch (Exception e) {
                if (!this.isDuplicateException(e)) {
                    throw e;
                }
                HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
                paramsMap.put("serverId", serverId);
                paramsMap.put("folderPath", folderPath);
                folderInfo = this.fileFolderInfoMapper.selectFolderByPath(paramsMap);
                this.putFolderInfoIntoCache(key, folderInfo);
                if (!addFolderVersionFlag) break block8;
                this.addFolderVersion(serverId, rootPath, folderPath, new Date());
            }
        }
        int n = folderPath.lastIndexOf("/");
        if (n > 0) {
            this.checkFileFolderInfoBottomUp(serverId, rootPath, folderPath.substring(0, n), false);
            return folderInfo;
        }
        return folderInfo;
    }

    public boolean deleteFileFolderInfoWithVersion(String serverId, long folderId, Integer version) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
        paramsMap.put("serverId", serverId);
        paramsMap.put("folderId", folderId);
        paramsMap.put("version", version);
        int deleteResult = this.fileFolderInfoMapper.deleteFileFolderInfoWithVersion(paramsMap);
        return deleteResult == 1;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean deleteFileInfo(FastDfsFileInfo info) {
        int deleteRet = this.fileInfoMapper.deleteFileInfo(info.getFileSeq());
        return deleteRet == 1;
    }

    public List<FastDfsFileInfo> queryFileInfo(String serverId, String fileName, String remotePathWithRoot) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("serverId", serverId);
        paramsMap.put("fileName", fileName);
        paramsMap.put("filePath", remotePathWithRoot);
        return this.fileInfoMapper.selectByNameAndPath(paramsMap);
    }

    public List<FastDfsFileInfo> queryFileInfosByIdAndGroup(String fileId, String fileGroup) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("fileId", fileId);
        paramsMap.put("fileGroup", fileGroup);
        return this.fileInfoMapper.selectFileInfoByIdAndGroup(paramsMap);
    }

    public List<FastDfsFileInfo> queryFileInfosInFolder(String serverId, String remotePath, Integer rowNum) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("serverId", serverId);
        paramsMap.put("filePath", remotePath);
        paramsMap.put("rowNum", rowNum);
        return this.fileInfoMapper.selectByNameAndPath(paramsMap);
    }

    public List<FastDfsFileInfo> queryFilesByFolderId(String serverId, long folderId) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
        paramsMap.put("serverId", serverId);
        paramsMap.put("folderId", folderId);
        return this.fileInfoMapper.selectFilesInFolder(paramsMap);
    }

    public FastDfsFolderInfo queryFolderByPath(String serverId, String remoteFolderPath) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
        paramsMap.put("serverId", serverId);
        paramsMap.put("folderPath", remoteFolderPath);
        return this.fileFolderInfoMapper.selectFolderByPath(paramsMap);
    }

    public List<FastDfsFolderInfo> querySubFolderInfos(String serverId, String remotePath) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        String folderPath = StringUtils.removeEnd((String)remotePath, (String)"/");
        paramsMap.put("serverId", serverId);
        paramsMap.put("parentFolderPath", folderPath);
        return this.fileFolderInfoMapper.selectSubFolderInfos(paramsMap);
    }

    private void putFolderInfoIntoCache(String key, FastDfsFolderInfo folderInfo) {
        try {
            if (this.maxFolderInfoCacheSize != 0 && serverFolderPathCache.size() > this.maxFolderInfoCacheSize) {
                serverFolderPathCache.clear();
            }
        }
        catch (Exception e) {
            logger.error("clean folderCache when full failed, max: {}", (Object)this.maxFolderInfoCacheSize, (Object)e);
        }
        serverFolderPathCache.put(key, folderInfo);
    }

    public void addFolderVersion(String serverId, String rootPath, String folderPathToAddVersion, Date updateTime) {
        if (!folderPathToAddVersion.startsWith(rootPath)) {
            folderPathToAddVersion = this.concatRelativePath(rootPath, folderPathToAddVersion);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("serverId", serverId);
        map.put("folderPath", folderPathToAddVersion);
        map.put("lastUpdateTime", updateTime);
        this.fileFolderInfoMapper.addFolderInfoVersion(map);
        String key = serverId.concat(":").concat(folderPathToAddVersion);
        serverFolderPathCache.remove(key);
    }

    public String removeFolderTailSeparatorIfExists(String remotePath) {
        return StringUtils.removeEnd((String)remotePath, (String)"/");
    }

    private boolean isDuplicateException(Exception ex) {
        return ex instanceof DuplicateKeyException;
    }

    public String concatRelativePath(String basePath, String relativePath) {
        String path = FilePathUtils.pathEscape((String)FilePathUtils.concatRelativePath((String)basePath, (String)relativePath));
        if (path != null && path.endsWith("/") && path.length() > 1) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getParentFolderPath(String remotePath) {
        String filePath = null;
        int lastIdx = remotePath.lastIndexOf("/");
        if (lastIdx > 0) {
            filePath = remotePath.substring(0, lastIdx);
        }
        return filePath;
    }

    public boolean isFolderExists(String serverId, String rootPath, String remotePath) {
        String fullPath = this.concatRelativePath(rootPath, remotePath);
        String key = serverId.concat(":").concat(fullPath);
        if (serverFolderPathCache.containsKey(key)) {
            return true;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
        paramsMap.put("serverId", serverId);
        paramsMap.put("folderPath", fullPath);
        FastDfsFolderInfo fastDfsFolderInfo = this.fileFolderInfoMapper.selectFolderByPath(paramsMap);
        if (fastDfsFolderInfo != null) {
            this.putFolderInfoIntoCache(key, fastDfsFolderInfo);
            return true;
        }
        return false;
    }

    public void deleteFolderPathCache(String serverId, String rootPath, String fullPath) {
        if (!fullPath.startsWith(rootPath)) {
            fullPath = this.concatRelativePath(rootPath, fullPath);
        }
        String key = serverId.concat(":").concat(fullPath);
        serverFolderPathCache.remove(key);
    }

    public int getMaxFolderInfoCacheSize() {
        return this.maxFolderInfoCacheSize;
    }

    public void setMaxFolderInfoCacheSize(int maxFolderInfoCacheSize) {
        this.maxFolderInfoCacheSize = maxFolderInfoCacheSize;
    }
}

