/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler.impl;

import cn.com.yusys.yusp.commons.biz.bizlog.BizLog;
import cn.com.yusys.yusp.commons.biz.bizlog.IBizLogSender;
import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.BizStoreException;
import cn.com.yusys.yusp.commons.exception.StoreException;
import cn.com.yusys.yusp.commons.exception.util.ExceptionUtils;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExceptionLogImpl
extends IExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionLogImpl.class);
    @Autowired(required=false)
    private IBizLogSender sender;

    public Object handleException(Exception exception) {
        BizException bizException;
        Throwable targetException = this.getBizStoreException(exception);
        int excepFlag = 0;
        if (targetException instanceof BizStoreException) {
            excepFlag = 1;
        } else if (exception instanceof StoreException) {
            excepFlag = 2;
            targetException = exception.getCause();
        }
        if (targetException == null) {
            targetException = exception;
        }
        if (Objects.nonNull(bizException = ExceptionUtils.tryFindYuspBizException(targetException))) {
            this.processYuspBizException(bizException);
        } else {
            log.error(targetException.getMessage(), targetException);
        }
        if (excepFlag == 1) {
            this.processBizStoreException((BizStoreException)targetException);
        } else if (excepFlag == 2) {
            this.processPlatStoreException((StoreException)exception);
        }
        return null;
    }

    private void processYuspBizException(BizException yuspBizException) {
        String info = yuspBizException.getErrorCode() + ":" + yuspBizException.getMessage();
        if (BizBaseException.BIZ_LEVEL.ERROR.equals((Object)yuspBizException.getLevel())) {
            log.error(info, (Throwable)yuspBizException);
        } else if (BizBaseException.BIZ_LEVEL.WARN.equals((Object)yuspBizException.getLevel())) {
            log.warn(info, (Throwable)yuspBizException);
        } else {
            log.info(info);
        }
    }

    private void processBizStoreException(BizStoreException bizStoreException) {
        if (this.sender != null) {
            this.sender.send(bizStoreException.getBizLog());
        }
    }

    private void processPlatStoreException(StoreException exception) {
        if (this.sender != null) {
            BizLog bizLog = new BizLog();
            bizLog.setBizTradeNum(exception.getBizNum());
            bizLog.setFuncNum(exception.getFuncNum());
            bizLog.setExcepDesc(exception.getMessage());
            this.sender.send(bizLog);
        }
    }

    public Throwable getBizStoreException(Throwable exception) {
        if (null == exception) {
            return null;
        }
        Throwable cause = exception.getCause();
        if (null == cause) {
            return null;
        }
        if (cause instanceof BizStoreException) {
            return cause;
        }
        return this.getBizStoreException(cause);
    }

    @Override
    public boolean shouldFilter(Exception exception) {
        Throwable targetException = this.getBizStoreException(exception);
        return targetException instanceof BizStoreException || targetException instanceof StoreException;
    }
}

