/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler.impl;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.ExceptionMessage;
import cn.com.yusys.yusp.commons.exception.util.ExceptionUtils;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionAfterHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.util.StringUtils;

public class ExceptionHandlerImpl
extends IExceptionHandler<Exception> {
    private IExceptionAfterHandler exceptionAfterHandler;
    private String severExceptionMessage;

    public ExceptionHandlerImpl(IExceptionAfterHandler exceptionAfterHandler) {
        this.exceptionAfterHandler = exceptionAfterHandler;
    }

    public String getSeverExceptionMessage() {
        return this.severExceptionMessage;
    }

    public void setSeverExceptionMessage(String severExceptionMessage) {
        this.severExceptionMessage = severExceptionMessage;
    }

    @Override
    public Object handleException(Exception exception) {
        ExceptionMessage exceptionMessage = this.parseExceptionMessage(exception);
        return this.writeExceptionToResponse(exceptionMessage, exception);
    }

    protected ExceptionMessage parseExceptionMessage(Exception exception) {
        String code = "500";
        String message = this.severExceptionMessage;
        if (StringUtils.isEmpty((CharSequence)message) && null == (message = ExceptionUtils.getExceptionMessage(exception))) {
            message = "[\u672a\u77e5\u5f02\u5e38]," + exception.getClass().getName();
        }
        if (exception instanceof BizException) {
            BizException exceptionT = (BizException)exception;
            code = exceptionT.getErrorCode();
            message = exceptionT.getMessage();
        }
        ExceptionMessage exceptionMessage = new ExceptionMessage();
        exceptionMessage.setCode(code);
        exceptionMessage.setMessage(message);
        return exceptionMessage;
    }

    protected Object writeExceptionToResponse(ExceptionMessage exceptionMessage, Exception exception) {
        if (null != this.exceptionAfterHandler) {
            return this.exceptionAfterHandler.handleException(exceptionMessage.getCode(), exceptionMessage.getMessage(), exception);
        }
        return null;
    }

    @Override
    public boolean shouldFilter(Exception exception) {
        return true;
    }
}

