/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler;

import cn.com.yusys.yusp.commons.exception.util.ExceptionUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class IExceptionHandler<T extends Exception> {
    public static final String EXCEPTION_CODE = "exception-code";
    public static final String EXCEPTION_MESSAGE = "exception-message";
    public static final String EXCEPTION_ERROR_CODE = "exception-error";
    public static final String EXCEPTION_CLASS = "exception-class";
    public static final String EXCEPTION_TRACEID = "exception-traceid";

    public abstract Object handleException(T var1);

    public abstract boolean shouldFilter(Exception var1);

    protected void writeResponseHeader(HttpServletResponse response) {
    }

    public void tag(Exception exception) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        response.addHeader(EXCEPTION_CLASS, ExceptionUtils.tryFindYuspBizExceptionClassName(exception));
        response.addHeader(EXCEPTION_TRACEID, MDC.get((String)"traceId"));
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
    }
}

