/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web;

import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.List;
import javax.annotation.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;

@ControllerAdvice
@Priority(value=1)
public class ExceptionTranslator {
    private final Logger logger = LoggerFactory.getLogger(ExceptionTranslator.class);
    private List<IExceptionHandler<? extends Exception>> exceptionHandlers;

    public ExceptionTranslator(List<IExceptionHandler<? extends Exception>> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object processException(Exception e, HandlerMethod handlerMethod) {
        this.logger.error(e.getMessage(), (Throwable)e);
        if (CollectionUtils.nonEmpty(this.exceptionHandlers)) {
            for (IExceptionHandler<? extends Exception> exceptionHandler : this.exceptionHandlers) {
                if (!exceptionHandler.shouldFilter(e)) continue;
                exceptionHandler.tag(e);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("class {} to handler exception {}", exceptionHandler, e.getClass());
                }
                return this.doHandleException(exceptionHandler, e, handlerMethod);
            }
        } else {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    Object doHandleException(IExceptionHandler exceptionHandler, Exception e, HandlerMethod handlerMethod) {
        return exceptionHandler.handleException(e);
    }
}

