/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.fegin;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.exception.util.ExceptionUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignErrorDecoder
implements ErrorDecoder {
    private final Logger logger = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        String exceptionClass = this.getExceptionInfo("exception-class", response);
        if (ExceptionUtils.isBizException(exceptionClass)) {
            try {
                String code = this.getExceptionInfo("exception-code", response);
                String message = this.getExceptionInfo("exception-message", response);
                String errorCode = this.getExceptionInfo("exception-error", response);
                message = URLDecoder.decode(message, "UTF-8");
                return BizException.error((String)code, (String)errorCode, (Object[])new Object[]{message});
            }
            catch (Exception e) {
                this.logger.warn("500 feign decoder exception error.");
            }
        } else if (ExceptionUtils.isPlatformException(exceptionClass)) {
            try {
                String message = URLDecoder.decode(this.getExceptionInfo("exception-message", response), "UTF-8");
                return new PlatformException(message);
            }
            catch (Exception e) {
                this.logger.warn("500 feign decoder exception error.");
            }
        }
        return FeignException.errorStatus((String)methodKey, (Response)response);
    }

    private String getExceptionInfo(String key, Response response) {
        return ExceptionUtils.getExceptionInfo(() -> {
            Map headers = response.headers();
            if (CollectionUtils.isEmpty((Map)headers)) {
                return null;
            }
            return (Collection)headers.get(key);
        });
    }
}

