/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.util;

import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.sql.entity.KeyEntityColumn;
import cn.com.yusys.yusp.commons.mapper.util.MapperUtils;
import cn.com.yusys.yusp.commons.mapper.util.OgnlUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.code.ORDER;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SelectKeyGenerator;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.util.StringUtil;

public class SqlUtils
extends SqlHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    public static String tableName(EntityTable entityTable, Config config) {
        String prefix = entityTable.getPrefix();
        if (StringUtil.isEmpty((String)prefix)) {
            prefix = config.getPrefix();
        }
        if (StringUtil.isNotEmpty((String)prefix)) {
            return prefix + "." + entityTable.getName();
        }
        return entityTable.getName();
    }

    public static String whereAllIfColumns(EntityTable entityTable, boolean notEmpty) {
        Class entityClass = entityTable.getEntityClass();
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn column : columnList) {
            sql.append(SqlUtils.getIfNotNullWithLike(null, column, notEmpty));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String getIfNotNullWithLike(String entityName, EntityColumn column, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (StringUtil.isNotEmpty((String)entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" != null");
        if (notEmpty && column.getJavaType().equals(String.class)) {
            sql.append(" and ");
            if (StringUtil.isNotEmpty((String)entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" != '' ");
        }
        sql.append("\">");
        if (column.getJavaType().equals(String.class)) {
            sql.append("<choose>");
            sql.append("<when test=\"@").append(OgnlUtils.class.getName()).append("@like(");
            if (StringUtil.isNotEmpty((String)entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty());
            sql.append(")\">");
            sql.append(" AND ").append(column.getColumn()).append(" like ").append(column.getColumnHolder(entityName));
            sql.append("</when>");
            sql.append("<otherwise>");
            sql.append(" AND ").append(column.getColumn()).append(" = ").append(column.getColumnHolder(entityName));
            sql.append("</otherwise>");
            sql.append("</choose>");
        } else {
            sql.append(" AND ").append(column.getColumn()).append(" = ").append(column.getColumnHolder(entityName));
        }
        sql.append("</if>");
        return sql.toString();
    }

    public static String insertValues(EntityTable entityTable, Config config, String entityName, boolean notNull) {
        boolean notEmpty = config.isNotEmpty();
        LinkedHashSet columnList = entityTable.getEntityClassColumns();
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlUtils.getIfCacheNotNull((EntityColumn)column, (String)column.getColumnHolder(entityName, "_cache", ",")));
            } else {
                sql.append(SqlUtils.getIfNotNull((String)entityName, (EntityColumn)column, (String)column.getColumnHolder(entityName, null, ","), (boolean)notEmpty));
            }
            if (column.isIdentity()) {
                sql.append(SqlUtils.getIfCacheIsNull((EntityColumn)column, (String)(column.getColumnHolder() + ",")));
                continue;
            }
            if (notNull) continue;
            sql.append(SqlUtils.getIfIsNull((String)entityName, (EntityColumn)column, (String)column.getColumnHolder(entityName, null, ","), (boolean)notEmpty));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static KeyGenerator newSelectKeyMappedStatement(String sqlId, String resource, Configuration configuration, EntityColumn column, Class<?> entityClass, Boolean executeBefore, String identity) {
        Jdbc3KeyGenerator keyGenerator;
        String IDENTITY;
        String keyId = sqlId + "!selectKey";
        if (configuration.hasKeyGenerator(keyId)) {
            return configuration.getKeyGenerator(keyId);
        }
        String string = IDENTITY = column.getGenerator() == null || "".equals(column.getGenerator()) ? identity : column.getGenerator();
        if ("JDBC".equalsIgnoreCase(IDENTITY)) {
            keyGenerator = new Jdbc3KeyGenerator();
        } else {
            RawSqlSource sqlSource = new RawSqlSource(configuration, IDENTITY, entityClass);
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, keyId, (SqlSource)sqlSource, SqlCommandType.SELECT);
            statementBuilder.resource(resource);
            statementBuilder.fetchSize(null);
            statementBuilder.statementType(StatementType.STATEMENT);
            statementBuilder.keyGenerator((KeyGenerator)new NoKeyGenerator());
            statementBuilder.keyProperty(column.getProperty());
            statementBuilder.keyColumn(null);
            statementBuilder.databaseId(null);
            statementBuilder.lang(configuration.getDefaultScriptingLanguageInstance());
            statementBuilder.resultOrdered(false);
            statementBuilder.resultSets(null);
            statementBuilder.timeout(configuration.getDefaultStatementTimeout());
            ArrayList parameterMappings = new ArrayList();
            ParameterMap.Builder inlineParameterMapBuilder = new ParameterMap.Builder(configuration, statementBuilder.id() + "-Inline", entityClass, parameterMappings);
            statementBuilder.parameterMap(inlineParameterMapBuilder.build());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap.Builder inlineResultMapBuilder = new ResultMap.Builder(configuration, statementBuilder.id() + "-Inline", column.getJavaType(), new ArrayList(), null);
            resultMaps.add(inlineResultMapBuilder.build());
            statementBuilder.resultMaps(resultMaps);
            statementBuilder.resultSetType(null);
            statementBuilder.flushCacheRequired(false);
            statementBuilder.useCache(false);
            statementBuilder.cache(null);
            MappedStatement statement = statementBuilder.build();
            try {
                configuration.addMappedStatement(statement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MappedStatement keyStatement = configuration.getMappedStatement(keyId, false);
            keyGenerator = new SelectKeyGenerator(keyStatement, column.getOrder() != ORDER.DEFAULT ? column.getOrder() == ORDER.BEFORE : executeBefore);
            try {
                configuration.addKeyGenerator(keyId, (KeyGenerator)keyGenerator);
            }
            catch (Exception e) {
                log.warn("add keyGenerator failure", (Throwable)e);
            }
        }
        return keyGenerator;
    }

    public static String whereInPkColumns(Class<?> entityClass) throws YuMapperException {
        StringBuilder sql = new StringBuilder();
        Set columnList = EntityHelper.getPKColumns(entityClass);
        if (columnList.size() != 1) {
            throw new YuMapperException("deleteByIds not support multi ID or none id");
        }
        EntityColumn column = (EntityColumn)columnList.iterator().next();
        sql.append(" where ");
        sql.append(column.getColumn());
        sql.append(" in ");
        sql.append(" <foreach collection=\"list\" open=\"(\" close=\")\" separator=\",\" item=\"").append(column.getProperty()).append("\">");
        sql.append(column.getColumnHolder());
        sql.append("</foreach>");
        return sql.toString();
    }

    public static KeyEntityColumn processKey(StringBuilder sql, Configuration configuration, EntityTable table, Config config, String method) throws YuMapperException {
        boolean hasIdentityKey = false;
        Class entityClass = table.getEntityClass();
        LinkedHashSet columnList = table.getEntityClassColumns();
        KeyEntityColumn keyEntityColumn = new KeyEntityColumn();
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                sql.append(SqlUtils.getBindCache((EntityColumn)column));
                if (hasIdentityKey) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new YuMapperException("\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                KeyGenerator keyGenerator = SqlUtils.newSelectKeyMappedStatement(MapperUtils.getSqlId(entityClass, method), "", configuration, column, entityClass, config.isBEFORE(), SqlUtils.getIDENTITY(column, config));
                keyEntityColumn.setEntityColumn(column);
                keyEntityColumn.setKeyGenerator(keyGenerator);
                hasIdentityKey = true;
                continue;
            }
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@tk.mybatis.mapper.genid.GenIdUtil@genId(");
            sql.append("_parameter").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getCanonicalName()).append("@class");
            sql.append(", '").append(SqlUtils.tableName(table, config)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
        return keyEntityColumn;
    }

    public static String getIDENTITY(EntityColumn column, Config config) {
        return MessageFormat.format(config.getIDENTITY(), column.getColumn(), column.getProperty(), column.getTable().getName());
    }

    public static String countColumn(EntityTable entityTable) {
        LinkedHashSet pkColumns = entityTable.getEntityClassPKColumns();
        if (pkColumns.size() == 1) {
            return ((EntityColumn)pkColumns.iterator().next()).getColumn();
        }
        return "*";
    }

    public static String exampleCheck(Class<?> entityClass, Config config) {
        StringBuilder sql = new StringBuilder();
        if (config.isCheckExampleEntityClass()) {
            sql.append(SqlUtils.exampleCheck(entityClass));
        }
        return sql.toString();
    }

    public static String exampleDistinct() {
        return "<if test=\"distinct\">distinct</if>";
    }

    public static String exampleSafeUpdate(Config config) {
        if (config.isSafeUpdate()) {
            return SqlUtils.exampleHasAtLeastOneCriteriaCheck((String)"example");
        }
        return "";
    }

    public static String exampleSafeDelete(Config config) {
        if (config.isSafeDelete()) {
            return SqlHelper.exampleHasAtLeastOneCriteriaCheck((String)"_parameter");
        }
        return "";
    }

    public String insertBatchValues() {
        return null;
    }
}

