/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.key.generator;

import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.key.annotation.RegisterKeyGenerator;
import cn.com.yusys.yusp.commons.mapper.key.generator.AbstractKeyGenerator;
import cn.com.yusys.yusp.commons.mybatis.annotation.IdentitySequence;
import cn.com.yusys.yusp.commons.mybatis.key.Sequence;
import cn.com.yusys.yusp.commons.mybatis.key.SequenceGenerator;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Objects;

@RegisterKeyGenerator(value="sequence")
public class SequenceKeyGenerator
extends AbstractKeyGenerator {
    private final SequenceGenerator sequenceGenerator;

    public SequenceKeyGenerator(Sequence sequence) {
        this.sequenceGenerator = new SequenceGenerator(sequence);
    }

    @Override
    public Number numberId(Object target, Class<?> entityClass, Field field) {
        this.check(entityClass, field.getName());
        return this.sequenceGenerator.nextId(target, entityClass);
    }

    @Override
    public String stringId(Object target, Class<?> entityClass, Field field) {
        this.check(entityClass, field.getName());
        return this.sequenceGenerator.nextUUID(target, entityClass);
    }

    private void check(Class<?> entityClass, String fileName) {
        IdentitySequence identitySequence = entityClass.getDeclaredAnnotation(IdentitySequence.class);
        if (Objects.isNull(identitySequence) || StringUtils.isEmpty((CharSequence)identitySequence.value())) {
            throw new YuMapperException(String.format("Current domain[%s] the primary key field[%s] not found SequenceGenerator annotation or value is empty!", entityClass, fileName));
        }
    }
}

