/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.idempotent;

import cn.com.yusys.yusp.commons.idempotent.IdempotentUtils;
import cn.com.yusys.yusp.commons.idempotent.annotation.Idempotent;
import cn.com.yusys.yusp.commons.idempotent.exception.IdempotentException;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.SpelUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class IdempotentAspect {
    private static final Logger logger = LoggerFactory.getLogger(IdempotentAspect.class);

    @Pointcut(value="@annotation(cn.com.yusys.yusp.commons.idempotent.annotation.Idempotent)")
    public void idempotent() {
    }

    @Around(value="idempotent()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        String[] spelExpressions;
        List convertIds;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        String name = StringUtils.buffer0((Object[])new Object[]{signature.getDeclaringTypeName(), ".", signature.getName()});
        String idempotentId = null;
        if (ArrayUtils.nonEmpty((Object[])idempotent.value()) && CollectionUtils.nonEmpty(convertIds = Arrays.stream(spelExpressions = idempotent.value()).map(expression -> SpelUtils.generateValueBySpel((String)expression, (Method)method, (Object[])joinPoint.getArgs())).filter(StringUtils::nonEmpty).collect(Collectors.toList()))) {
            idempotentId = StringUtils.concat(convertIds, (String)".");
        }
        Asserts.nonEmpty(idempotentId, (String[])new String[]{"Idempotent id must not null or empty!"});
        name = StringUtils.builder0((Object[])new Object[]{name, "-", idempotentId});
        logger.debug("The idempotent operation currently executed is: Method[{}.{}], Idempotent Id[{}]", new Object[]{signature.getDeclaringTypeName(), signature.getName(), idempotentId});
        return IdempotentUtils.execute(name, new AopExecutor(joinPoint));
    }

    private static final class AopExecutor
    implements Supplier<Object> {
        private final ProceedingJoinPoint joinPoint;

        public AopExecutor(ProceedingJoinPoint joinPoint) {
            this.joinPoint = joinPoint;
        }

        @Override
        public Object get() {
            try {
                return this.joinPoint.proceed();
            }
            catch (Throwable e) {
                throw new IdempotentException(e);
            }
        }
    }
}

