/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class LoggerSerializeUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final JavaType MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);

    private LoggerSerializeUtils() {
    }

    public static ObjectMapper instance() {
        return objectMapper;
    }

    public static String writeAsString(Object object) throws JsonProcessingException {
        return objectMapper.writeValueAsString(object);
    }

    public static Map<String, Object> readAsMap(InputStream inputStream) throws IOException {
        return (Map)objectMapper.readValue(inputStream, MAP_TYPE);
    }

    public static Map<String, Object> readAsMap(String src) throws IOException {
        return (Map)objectMapper.readValue(src, MAP_TYPE);
    }

    static {
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, false);
    }
}

