/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.collect;

import cn.com.yusys.yusp.commons.log.common.collect.TimedCollector;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class TimedTaskExecutor {
    private final Logger logger = LoggerFactory.getLogger(TimedTaskExecutor.class);
    private final List<TimedCollector> collectors;
    private final TaskScheduler scheduler;

    public TimedTaskExecutor(TaskScheduler scheduler, List<TimedCollector> collectors) {
        this.scheduler = scheduler;
        this.collectors = collectors;
    }

    public void init() {
        if (this.collectors != null && !this.collectors.isEmpty()) {
            for (TimedCollector collector : this.collectors) {
                this.logger.debug("Add Logging :{}Collect Task.", collector.getClass());
                this.scheduler.schedule((Runnable)collector, collector.getTrigger());
            }
        }
    }
}

