/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.annotation;

import cn.com.yusys.yusp.commons.config.annotation.ItemChangeListenerRegister;
import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.config.core.ChangeItem;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import cn.com.yusys.yusp.commons.config.utils.ConfigUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.MethodInvoker;

public class SingleItemChangeListenerRegister
implements ItemChangeListenerRegister {
    private Map<String, Map<String, List<MethodInvoker>>> keyListeners = new HashMap<String, Map<String, List<MethodInvoker>>>();

    @Override
    public void addListener(String dataId, String methodName, Object target, String ... interestedKeys) {
        Arrays.stream(interestedKeys).flatMap(key -> Arrays.stream(StringUtils.split((String)key, (String)","))).filter(StringUtils::nonBlank).map(StringUtils::trim).forEach(key -> this.addKeyListener(dataId, methodName, target, (String)key));
    }

    private void addKeyListener(String dataId, String methodName, Object target, String interestedKey) {
        this.keyListeners.putIfAbsent(dataId, new HashMap());
        Map<String, List<MethodInvoker>> keyMap = this.keyListeners.get(dataId);
        keyMap.putIfAbsent(interestedKey, new ArrayList());
        List<MethodInvoker> invokers = keyMap.get(interestedKey);
        invokers.add(ConfigUtils.buildMethodInvoker(methodName, target));
    }

    @Override
    public void register(ConfigTemplate configTemplate) {
        Set<Map.Entry<String, Map<String, List<MethodInvoker>>>> entries = this.keyListeners.entrySet();
        for (Map.Entry<String, Map<String, List<MethodInvoker>>> entry : entries) {
            String dataId = entry.getKey();
            Map<String, List<MethodInvoker>> keyMap = entry.getValue();
            Set<String> interestedKeys = keyMap.keySet();
            configTemplate.addListener(dataId, interestedKeys, event -> {
                Map<String, ChangeItem> changes = event.getChanges();
                changes.forEach((k, v) -> {
                    ChangeEvent cce = new ChangeEvent().addChange((String)k, (ChangeItem)v);
                    List invokers = (List)keyMap.get(k);
                    if (invokers != null) {
                        invokers.forEach(invoker -> ConfigUtils.invoke(invoker, cce));
                    }
                });
            });
        }
    }

    @Override
    public String[] interestedKeys() {
        return (String[])this.keyListeners.values().stream().map(Map::keySet).flatMap(Collection::stream).distinct().toArray(String[]::new);
    }
}

