/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.util;

import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatUtils;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.util.Objects;

public class IdConverterUtils {
    public static String getSequenceIdSuffix(CycleType cycleType) {
        return IdConverterUtils.getSequenceIdSuffix(cycleType, LocalDate.now());
    }

    private static String getSequenceIdSuffix(CycleType cycleType, LocalDate localDate) {
        if (Objects.isNull((Object)cycleType)) {
            return "";
        }
        String suffix = "";
        switch (cycleType) {
            case DAY: {
                suffix = localDate.format(DateFormatUtils.DATE_COMPACT_FORMATTER);
                break;
            }
            case MONTH: {
                suffix = localDate.format(DateFormatUtils.YEAR_MONTH_FORMATTER);
                break;
            }
            case YEAR: {
                suffix = localDate.format(DateFormatUtils.YEAR_FORMATTER);
                break;
            }
            case SEASON: {
                int season = localDate.getMonthValue() / 3 + 1;
                suffix = StringUtils.builder0((Object[])new Object[]{localDate.format(DateFormatUtils.YEAR_FORMATTER), "_", season, "S"});
                break;
            }
            case WEEK: {
                suffix = StringUtils.builder0((Object[])new Object[]{localDate.format(DateFormatUtils.YEAR_FORMATTER), "_", localDate.getLong(IsoFields.WEEK_OF_WEEK_BASED_YEAR), "W"});
                break;
            }
            case HALF_Y: {
                int halfYear = localDate.getMonth().getValue() < 7 ? 1 : 2;
                suffix = StringUtils.builder0((Object[])new Object[]{localDate.format(DateFormatUtils.YEAR_FORMATTER), "_", halfYear, "Y"});
                break;
            }
        }
        return suffix;
    }

    public static String getFrontIdSuffix(CycleType cycleType, int reserve) {
        LocalDate localDate = LocalDate.now();
        switch (cycleType) {
            case DAY: {
                localDate = localDate.plusDays(-reserve);
                break;
            }
            case MONTH: {
                localDate = localDate.plusMonths(-reserve);
                break;
            }
            case YEAR: {
                localDate = localDate.plusYears(-reserve);
                break;
            }
            case SEASON: {
                localDate = localDate.plusMonths((long)(-reserve) * 3L);
                break;
            }
            case WEEK: {
                localDate = localDate.plusDays((long)(-reserve) * 7L);
                break;
            }
            case HALF_Y: {
                localDate = localDate.plusMonths((long)(-reserve) * 6L);
                break;
            }
        }
        return IdConverterUtils.getSequenceIdSuffix(cycleType, localDate);
    }
}

