/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.algorithm;

import cn.com.yusys.yusp.commons.sequence.AbstractSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.IdUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeSequenceGenerator
extends AbstractSequenceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SnowflakeSequenceGenerator.class);
    private long currentSeqNo = IdUtils.getDefaultSnowflake().nextId();

    public SnowflakeSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter) {
        super(sequenceConfigs, sequenceIdConverter);
    }

    public SnowflakeSequenceGenerator(List<SequenceConfig> sequenceConfigs) {
        super(sequenceConfigs);
    }

    @Override
    public long getCurrentSequenceNo(String seqId) throws SequenceException {
        this.checkSequenceConfig(seqId);
        return this.currentSeqNo;
    }

    @Override
    public synchronized long getSequenceNo(String seqId) throws SequenceException {
        this.checkSequenceConfig(seqId);
        this.currentSeqNo = IdUtils.getDefaultSnowflake().nextId();
        return this.currentSeqNo;
    }

    @Override
    public String getSequence(String seqId, Map<String, String> paramMap) throws SequenceException {
        this.checkSequenceConfig(seqId);
        String convertId = this.getSequenceIdConverter().convert(seqId);
        return this.parseSequenceByTemplate(convertId, String.valueOf(this.getSequenceNo(convertId)), paramMap);
    }

    @Override
    public boolean createSequence(String seqId) {
        throw new UnsupportedOperationException("Snowflake algorithm generator unsupported Current operation! ");
    }

    private void checkSequenceConfig(String seqId) {
        SequenceConfig sequenceConfig = this.getSequenceConfig(seqId);
        Asserts.nonNull((Object)sequenceConfig, (Object[])new Object[]{"Sequence Id [%s] not found config information!", seqId});
        if (!CycleType.NONE.equals((Object)sequenceConfig.getCycleType())) {
            logger.warn("Current algorithm not support sequence reset!");
        }
    }

    @Override
    public int cleanup(String ... seqIds) {
        logger.warn("Snowflake algorithm No need to clean up");
        return 0;
    }

    public String supportedType() {
        return GeneratorType.SNOWFLAKE.name();
    }
}

