/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence;

import cn.com.yusys.yusp.commons.sequence.AbstractSequence;
import cn.com.yusys.yusp.commons.sequence.ExpiredClean;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceGeneratorType;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.util.IdConverterUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cglib.proxy.Proxy;

public abstract class AbstractSequenceGenerator
extends AbstractSequence
implements SequenceGeneratorType,
ExpiredClean {
    private static final String PROXY_CONVERT_METHOD_NAME = "convert";
    private static final Map<String, Object> CREATE_LOCKS = new ConcurrentHashMap<String, Object>();
    private SequenceIdConverter converter;

    public AbstractSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter) {
        super(sequenceConfigs, sequenceIdConverter);
    }

    public AbstractSequenceGenerator(List<SequenceConfig> sequenceConfigs) {
        super(sequenceConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceIdConverter getSequenceIdConverter() {
        if (Objects.isNull(this.converter)) {
            AbstractSequenceGenerator abstractSequenceGenerator = this;
            synchronized (abstractSequenceGenerator) {
                SequenceIdConverter superConverter = super.getSequenceIdConverter();
                this.converter = SequenceIdConverter.DefaultConverter.class.isAssignableFrom(superConverter.getClass()) ? superConverter : (SequenceIdConverter)Proxy.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{SequenceIdConverter.class}, (o, method, objects) -> {
                    if (PROXY_CONVERT_METHOD_NAME.equals(method.getName())) {
                        String seqId = StringUtils.replaceObjNull((Object)objects[0]);
                        String convertId = superConverter.convert(seqId);
                        SequenceConfig sequenceConfig = super.getSequenceConfig(seqId);
                        if (!CycleType.NONE.equals((Object)sequenceConfig.getCycleType())) {
                            return StringUtils.buffer0((Object[])new Object[]{convertId, IdConverterUtils.getSequenceIdSuffix(sequenceConfig.getCycleType())});
                        }
                        return convertId;
                    }
                    return method.invoke(o, objects);
                });
            }
        }
        return this.converter;
    }

    protected Object getLockObject(String seqId) {
        return CREATE_LOCKS.computeIfAbsent(seqId, id -> new Object());
    }

    protected void removeLockObject(String seqId) {
        CREATE_LOCKS.remove(seqId);
    }
}

