/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.db;

import cn.com.yusys.yusp.commons.enumeration.DbType;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.sequence.generator.db.AbstractDatabaseSequenceGenerator;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class Db2SequenceGenerator
extends AbstractDatabaseSequenceGenerator {
    public Db2SequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, JdbcTemplate jdbcTemplate) {
        super(sequenceConfigs, sequenceIdConverter, jdbcTemplate);
    }

    @Override
    String querySql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"SELECT count(*) FROM SYSCAT.SEQUENCES where SEQNAME= '", seqId, "'"});
    }

    @Override
    String batchNextSql(String sequenceName, int number) {
        throw new UnsupportedOperationException("current database is not supported batch get sequence sql!");
    }

    @Override
    String dropSql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"drop sequence ", seqId});
    }

    @Override
    String createSql(String seqId, SequenceConfig config) {
        return StringUtils.builder0((Object[])new Object[]{"create sequence ", seqId, " as bigint minvalue ", config.getStartValue(), " maxvalue ", config.getMaxValue(), " start with ", config.getStartValue(), " increment by ", config.getIncrementValue(), " cache ", config.getCacheValue(), CycleType.MAX.equals((Object)config.getCycleType()) ? " cycle " : ""});
    }

    @Override
    protected String nextSql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"values nextval for ", seqId});
    }

    @Override
    String currentSql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"values prevval for ", seqId});
    }

    public boolean isSupported(DbType type) {
        return DbType.DB2.equals((Object)type);
    }

    public String supportedType() {
        return GeneratorType.DB2.name();
    }
}

