/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.util;

import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.collection.KeyValue;
import cn.com.yusys.yusp.commons.util.collection.NullableKeyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;

public class JsonConfigUtils {
    public static <T> T doParse(String oldContent, String newContent, BiFunction<Properties, Properties, T> compareFunction) {
        Map oldMap = (Map)ObjectMapperUtils.toObject((String)oldContent, HashMap.class);
        Map newMap = (Map)ObjectMapperUtils.toObject((String)newContent, HashMap.class);
        Properties oldProps = JsonConfigUtils.mapToProperties(oldMap);
        Properties newProps = JsonConfigUtils.mapToProperties(newMap);
        return compareFunction.apply(oldProps, newProps);
    }

    private static Properties mapToProperties(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return new Properties();
        }
        List<KeyValue<String, String>> keyValues = JsonConfigUtils.convert(map);
        Properties properties = new Properties();
        keyValues.forEach(keyValue -> properties.setProperty((String)keyValue.getKey(), (String)keyValue.getValue()));
        return properties;
    }

    private static List<KeyValue<String, String>> convert(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        ArrayList<KeyValue<String, String>> list = new ArrayList<KeyValue<String, String>>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            List valueList;
            if (entry.getValue() instanceof Map) {
                valueList = JsonConfigUtils.convert((Map)entry.getValue());
                valueList.forEach(kv -> list.add((KeyValue<String, String>)NullableKeyValue.ofNullable((Object)StringUtils.builder0((Object[])new Object[]{entry.getKey(), ".", kv.getKey()}), (Object)kv.getValue())));
                continue;
            }
            if (entry.getValue() instanceof List) {
                valueList = (List)entry.getValue();
                for (int i = 0; i < valueList.size(); ++i) {
                    list.add((KeyValue<String, String>)NullableKeyValue.ofNullable((Object)StringUtils.buffer0((Object[])new Object[]{entry.getKey(), "[", i, "]"}), (Object)StringUtils.replaceObjNull(valueList.get(i))));
                }
                continue;
            }
            list.add((KeyValue<String, String>)NullableKeyValue.ofNullable((Object)entry.getKey(), (Object)StringUtils.replaceObjNull((Object)entry.getValue())));
        }
        return list;
    }
}

