/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.apollo;

import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleHelper;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.util.ClassUtils;

public class ConfigurationPropertiesRefreshListener
implements ConfigChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPropertiesRefreshListener.class);
    private final RefreshScope refreshScope;

    public ConfigurationPropertiesRefreshListener(RefreshScope refreshScope) {
        this.refreshScope = refreshScope;
    }

    public void onChange(ConfigChangeEvent changeEvent) {
        Set keys = changeEvent.changedKeys();
        List modules = ModuleHelper.modules();
        ConcurrentHashMap<String, Module> refreshMap = new ConcurrentHashMap<String, Module>();
        for (Module module : modules) {
            boolean matcher;
            String prefix = module.getProperty().getPrefix();
            if (!StringUtils.nonEmpty((CharSequence)prefix) || refreshMap.containsKey(module.getName()) || !(matcher = keys.stream().anyMatch(key -> key.startsWith(prefix)))) continue;
            refreshMap.put(module.getName(), module);
        }
        this.refresh(refreshMap);
    }

    private void refresh(Map<String, Module> refreshMap) {
        refreshMap.values().forEach(this::refresh);
    }

    private void refresh(Module module) {
        String configClassesStr = module.getProperty().getClasses();
        if (StringUtils.nonEmpty((CharSequence)configClassesStr) && configClassesStr.trim().length() > 0) {
            String[] configClasses = StringUtils.split((String)configClassesStr, (String)",");
            Arrays.stream(configClasses).filter(StringUtils::nonEmpty).forEach(this::refresh);
        } else {
            log.warn("Current module[{}] not config class", (Object)module.getName());
        }
    }

    private void refresh(String configClass) {
        if (StringUtils.nonEmpty((CharSequence)configClass) || configClass.trim().length() > 0) {
            String name = null;
            try {
                name = ClassUtils.forName((String)configClass.trim(), null).getName();
            }
            catch (Exception e) {
                log.error("Config class[" + configClass + "] not found! cause by:" + e.getMessage(), (Throwable)e);
            }
            if (name != null) {
                StringBuilder builder = new StringBuilder(name);
                builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
                this.refreshScope.refresh(builder.toString());
            }
        }
    }
}

