/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.apollo;

import cn.com.yusys.yusp.commons.module.constant.DynamicFrameworks;
import cn.com.yusys.yusp.commons.util.Predicates;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationEvent;

public class CloudConfigChangeListener
implements ConfigChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CloudConfigChangeListener.class);
    private Predicate<String> regexPre = null;

    public CloudConfigChangeListener(String regex) {
        if (StringUtils.nonEmpty((CharSequence)regex)) {
            List predicates = Arrays.stream(regex.split(",")).filter(StringUtils::nonEmpty).map(String::trim).map(Predicates::regex).collect(Collectors.toList());
            this.regexPre = Predicates.or(predicates);
        }
    }

    public void onChange(ConfigChangeEvent changeEvent) {
        log.debug("Apollo config change ,Publish EnvironmentChangeEvent");
        Set changeKeys = changeEvent.changedKeys();
        if (changeKeys == null || changeKeys.isEmpty()) {
            log.warn("Empty Apollo Change Keys,Not Publish");
            return;
        }
        if (this.regexPre != null) {
            log.debug("Filter un match keys");
            Predicate<String> dynamicKeys = DynamicFrameworks.dynamicKeysPre().or(this.regexPre);
            changeKeys = changeKeys.stream().filter(dynamicKeys).collect(Collectors.toSet());
        }
        if (changeKeys != null && !changeKeys.isEmpty()) {
            SpringContextUtils.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changeKeys));
        }
    }
}

