/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.filter;

import cn.com.yusys.yusp.commons.swagger.util.RequestMatcherUtils;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ProductionSecurityFilter
implements Filter {
    private boolean production = false;
    private final Predicate<String> apiPredicate = RequestMatcherUtils.pathPredicate("/doc.html,/swagger-ui*.html,/webjars/bycdao-ui/**,/swagger-resources/**,/v2/api-docs,/*/v2/api-docs").get();

    public ProductionSecurityFilter() {
    }

    public ProductionSecurityFilter(boolean production) {
        this.production = production;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.setProduction(Boolean.parseBoolean(filterConfig.getInitParameter("prod")));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.production) {
            String uri = httpServletRequest.getRequestURI();
            if (this.apiPredicate.test(uri)) throw new AccessControlException("\u751f\u4ea7\u73af\u5883\u7981\u6b62\u4f7f\u7528Swagger\u8fdb\u884c\u63a5\u53e3\u67e5\u770b");
            chain.doFilter(request, response);
            return;
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }
}

