/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.zuul;

import cn.com.yusys.yusp.commons.ribbon.util.RouteUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

public class ZuulPropertiesBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
EnvironmentAware {
    private final Logger log = LoggerFactory.getLogger(ZuulPropertiesBeanPostProcessor.class);
    private Environment environment;

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) {
        if (bean instanceof ZuulProperties) {
            ZuulProperties zuulProperties = (ZuulProperties)bean;
            return this.enhance(zuulProperties);
        }
        return bean;
    }

    private ZuulProperties enhance(ZuulProperties zuulProperties) {
        this.log.debug("Init routes config.");
        Map routes = zuulProperties.getRoutes();
        AtomicInteger num = new AtomicInteger(0);
        RouteUtils.initRoutes(this.environment, (path, id, stripPrefix) -> {
            String key = id + num.incrementAndGet();
            ZuulProperties.ZuulRoute route = new ZuulProperties.ZuulRoute();
            route.setStripPrefix(stripPrefix.booleanValue());
            route.setServiceId(id);
            route.setId(key);
            route.setPath(path);
            routes.put(key, route);
        }, (name, id) -> {});
        return zuulProperties;
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeforeDestruction(@NonNull Object bean, @NonNull String beanName) {
        if (bean instanceof ZuulProperties) {
            ZuulProperties zuulProperties = (ZuulProperties)bean;
            zuulProperties.getRoutes().clear();
        }
    }
}

