/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.util;

import cn.com.yusys.yusp.commons.ribbon.TriConsumer;
import cn.com.yusys.yusp.commons.ribbon.config.ServiceMappingProperties;
import cn.com.yusys.yusp.commons.ribbon.constant.RequestConstants;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public final class RouteUtils {
    private static final Logger log = LoggerFactory.getLogger(RouteUtils.class);

    private RouteUtils() {
    }

    public static void initRoutes(Environment environment, TriConsumer<String, String, Boolean> pathConsumer, BiConsumer<String, String> feignConsumer) {
        ServiceMappingProperties mappingProperties = RouteUtils.serviceMappingProperties(environment);
        if (Objects.nonNull(mappingProperties)) {
            String globalPrefix = mappingProperties.getPathPrefix();
            Map<String, String> routeConfigMap = mappingProperties.getRoutes();
            if (CommonUtils.nonNullOrEmpty(routeConfigMap)) {
                routeConfigMap.forEach((serviceId, routeConfig) -> RouteUtils.initRoute(serviceId, routeConfig, globalPrefix, mappingProperties.isStripPrefix(), pathConsumer, feignConsumer));
            }
        }
    }

    public static ServiceMappingProperties serviceMappingProperties(Environment environment) {
        BindResult result = Binder.get((Environment)environment).bind("yusp.service", ServiceMappingProperties.class);
        return result.isBound() ? (ServiceMappingProperties)result.get() : null;
    }

    public static void initRoute(String serviceId, String routeConfig, String globalPrefix, Boolean stripPrefix, TriConsumer<String, String, Boolean> pathConsumer, BiConsumer<String, String> feignConsumer) {
        log.debug("Init route config.");
        String[] feignNames = routeConfig == null ? new String[]{RouteUtils.defaultFeignName(serviceId)} : routeConfig.split(",");
        Arrays.stream(feignNames).forEach(feignName -> {
            feignConsumer.accept((String)feignName, serviceId);
            String pattern = globalPrefix + feignName + "/**";
            pathConsumer.accept(pattern, serviceId, stripPrefix);
        });
    }

    public static String defaultFeignName(String serviceId) {
        return serviceId.replace("-", RequestConstants.REQUEST_PATH_SPLIT);
    }
}

