/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.feign;

import cn.com.yusys.yusp.commons.ribbon.RouteMappingLocator;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;

public class RouteFeignBeanDefinitionRegistryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private final Logger log = LoggerFactory.getLogger(RouteFeignBeanDefinitionRegistryPostProcessor.class);
    private final RouteMappingLocator routeMappingLocator;

    public RouteFeignBeanDefinitionRegistryPostProcessor(RouteMappingLocator routeMappingLocator) {
        this.routeMappingLocator = routeMappingLocator;
    }

    private String getMappingService(String originService) {
        return this.routeMappingLocator.extractServiceIdByFeignName(originService);
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) {
        this.log.debug("postProcessBeanFactory BeanFactory.");
        Object[] names = beanFactory.getBeanNamesForAnnotation(FeignClient.class);
        if (CommonUtils.nonNullOrEmpty((Object[])names)) {
            Arrays.stream(names).forEach(beanName -> this.overrideBeanDefinition((String)beanName, beanFactory));
        }
    }

    private void overrideBeanDefinition(String beanName, @NonNull ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
        MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
        String serviceId = this.getMappingService(mutablePropertyValues.get("name").toString());
        if (serviceId == null) {
            return;
        }
        mutablePropertyValues.add("name", (Object)serviceId);
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            registry.removeBeanDefinition(beanName);
            registry.registerBeanDefinition(beanName, beanDefinition);
        }
    }

    public int getOrder() {
        return 2147483597;
    }
}

