/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.dev;

import cn.com.yusys.yusp.commons.ribbon.exception.RouteException;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DevModePreferRule
extends ZoneAvoidanceRule {
    public static final String DEV_MODE_HEADER = "devMode";
    private static final Logger log = LoggerFactory.getLogger(DevModePreferRule.class);
    private static final JavaType MAP_STRING_STRING_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, String.class);
    private final ObjectMapper mapper = new ObjectMapper();

    protected Map<String, String> getDevModeConfig() throws IOException {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        HttpServletRequest request = attributes.getRequest();
        String devModeString = request.getHeader(DEV_MODE_HEADER);
        if (StringUtils.isEmpty((CharSequence)devModeString)) {
            return null;
        }
        return this.convert(devModeString);
    }

    protected Map<String, String> convert(String devModeString) throws IOException {
        return (Map)this.mapper.readValue(devModeString, MAP_STRING_STRING_TYPE);
    }

    public Server choose(Object key) {
        try {
            Map<String, String> devMode = this.getDevModeConfig();
            if (CommonUtils.isNullOrEmpty(devMode)) {
                log.debug("request not exists devMode config.");
                return null;
            }
            List serverList = this.getLoadBalancer().getAllServers();
            if (CommonUtils.isNullOrEmpty((Collection)serverList)) {
                log.debug("request app not exists instance.");
                return null;
            }
            String appId = ((Server)serverList.get(0)).getMetaInfo().getAppName();
            String matchedHostPort = this.matchedHostPort(devMode, appId);
            if (StringUtils.nonEmpty((CharSequence)matchedHostPort)) {
                log.debug("request app :{} exists devMode config:{}.", (Object)appId, devMode);
                Optional<Server> serverOptional = serverList.stream().filter(server -> matchedHostPort.equalsIgnoreCase(server.getHostPort())).findFirst();
                if (serverOptional.isPresent()) {
                    return serverOptional.get();
                }
                throw new RouteException(StringUtils.format((String)"App[{}] devMode exists hostPort:{},but not found server,server list:{}.", (Object[])new Object[]{appId, matchedHostPort, serverList}));
            }
        }
        catch (IOException e) {
            log.warn("error route dev mode configure. message:{}", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    String matchedHostPort(Map<String, String> devModeConfig, String appId) {
        if (CommonUtils.nonNullOrEmpty(devModeConfig)) {
            for (Map.Entry<String, String> entry : devModeConfig.entrySet()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

