/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon;

import cn.com.yusys.yusp.commons.util.CommonUtils;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRule
extends ZoneAvoidanceRule {
    private static final Logger log = LoggerFactory.getLogger(CompositeRule.class);
    public static final String COMPOSITE_RULE_FACTORY = "RuleListFactory";
    private static final IRule DEFAULT_RULE = new RoundRobinRule();
    private static final RuleClientConfigKey RULE_CLIENT_CONFIG_KEY = new RuleClientConfigKey();
    private List<IRule> ruleList = Collections.singletonList(DEFAULT_RULE);

    public void setRuleList(List<IRule> ruleList) {
        this.ruleList = ruleList;
    }

    public Server choose(Object key) {
        Server server = this.chooseInternal(key, this.ruleList);
        if (log.isInfoEnabled() && Objects.nonNull(server)) {
            log.info("service[{}]-->location:{}.", (Object)server.getMetaInfo().getAppName(), (Object)server.getHostPort());
        }
        return server;
    }

    Server chooseInternal(Object key, List<IRule> rules) {
        return rules.stream().filter(Objects::nonNull).map(rule -> this.chooseServer((IRule)rule, key)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    Server chooseServer(IRule rule, Object key) {
        log.debug("exec route rule :{}", rule.getClass());
        Server server = rule.choose(key);
        if (log.isDebugEnabled()) {
            if (server == null) {
                log.debug("current rule:{} cannot fetch a available server", rule.getClass());
            } else {
                log.debug("current route rule :{} matched,fetch available server:{}", rule.getClass(), (Object)server.getHostPort());
            }
        }
        return server;
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        this.ruleList.forEach(rule -> rule.setLoadBalancer(lb));
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        CompositeRule rule = (CompositeRule)((Object)clientConfig.get((IClientConfigKey)CompositeRule.getInstance()));
        if (Objects.isNull((Object)rule) || CommonUtils.isNullOrEmpty(rule.getRuleList())) {
            log.warn("\u4e0d\u5b58\u5728\u914d\u7f6e\u7684\u8def\u7531\u89c4\u5219. ");
            this.ruleList = Collections.singletonList(DEFAULT_RULE);
        } else {
            this.ruleList = rule.getRuleList();
        }
        super.initWithNiwsConfig(clientConfig);
    }

    public List<IRule> getRuleList() {
        return this.ruleList;
    }

    public static RuleClientConfigKey getInstance() {
        return RULE_CLIENT_CONFIG_KEY;
    }

    static class RuleClientConfigKey
    implements IClientConfigKey<CompositeRule> {
        RuleClientConfigKey() {
        }

        public String key() {
            return CompositeRule.COMPOSITE_RULE_FACTORY;
        }

        public Class<CompositeRule> type() {
            return CompositeRule.class;
        }
    }
}

