/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.util;

import cn.com.yusys.yusp.commons.session.SessionService;
import cn.com.yusys.yusp.commons.session.context.UserContext;
import cn.com.yusys.yusp.commons.session.user.Control;
import cn.com.yusys.yusp.commons.session.user.DataControl;
import cn.com.yusys.yusp.commons.session.user.MenuControl;
import cn.com.yusys.yusp.commons.session.user.User;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.List;

public final class SessionUtils {
    private static SessionService sessionService;

    private static void check() {
        if (sessionService == null) {
            SessionUtils.init();
        }
    }

    private static synchronized void init() {
        if (sessionService == null) {
            sessionService = (SessionService)SpringContextUtils.getBeanProvider(SessionService.class).getIfAvailable(SessionService.DefaultSessionService::new);
        }
    }

    public static String getUserId() {
        UserContext user = UserContext.getUserContext();
        return user != null ? user.getUserId() : null;
    }

    public static String getLoginCode() {
        UserContext user = UserContext.getUserContext();
        return user != null ? user.getLoginCode() : null;
    }

    public static String getUserOrganizationId() {
        UserContext user = UserContext.getUserContext();
        return user != null ? user.getOrganizationId() : null;
    }

    public static String getClientId() {
        UserContext user = UserContext.getUserContext();
        return user != null ? user.getClientId() : null;
    }

    public static User getUserInformation() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getUserInfo(user.getClientId(), user.getUserId());
        }
        return null;
    }

    public static <T extends Control> List<T> getAllControls() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getAllControls(user.getClientId(), user.getUserId());
        }
        return null;
    }

    public static MenuControl getMenuControl() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getMenuControl(user.getClientId(), user.getUserId());
        }
        return null;
    }

    public static <T extends DataControl> List<T> getDataControl() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getDataControl(user.getClientId(), user.getUserId());
        }
        return null;
    }
}

