/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.sentinel.locator;

import com.alibaba.cloud.sentinel.datasource.RuleType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order(value=100)
public class UcSentinelPropertySourceLocator
implements PropertySourceLocator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENABLE_KEY = "udp.cloud.sentinel.enabled";
    private static final String SOURCE_NAME = "udp-cloud-sentinel.properties";
    private static final String FALSE_NAME = "false";

    public PropertySource<?> locate(Environment env) {
        String enabled = env.getProperty(ENABLE_KEY);
        if (FALSE_NAME.equals(enabled)) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.setSentinelDefault(env, map);
        if (this.supportNacos()) {
            this.setSentinelDataSource(env, map);
        }
        StringBuilder msg = new StringBuilder(SOURCE_NAME);
        for (String key : map.keySet()) {
            msg.append("\n").append(key).append("=").append(map.get(key));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[udp-cloud]: {}", (Object)msg);
        }
        this.logger.info("[udp-cloud]: set sentinel config");
        return new MapPropertySource(SOURCE_NAME, map);
    }

    private boolean supportNacos() {
        try {
            Class.forName("com.alibaba.cloud.nacos.NacosConfigProperties");
            Class.forName("com.alibaba.csp.sentinel.datasource.nacos.NacosDataSource");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private void setSentinelDefault(Environment environment, Map<String, Object> params) {
        String healthSentinelEnabled;
        String feignSentinelEnabled;
        String webContextUnify;
        String httpMethodSpecify = environment.getProperty("spring.cloud.sentinel.http-method-specify");
        if (httpMethodSpecify == null) {
            params.put("spring.cloud.sentinel.http-method-specify", true);
        }
        if ((webContextUnify = environment.getProperty("spring.cloud.sentinel.web-context-unify")) == null) {
            params.put("spring.cloud.sentinel.web-context-unify", false);
        }
        if ((feignSentinelEnabled = environment.getProperty("feign.sentinel.enabled")) == null) {
            params.put("feign.sentinel.enabled", true);
        }
        if ((healthSentinelEnabled = environment.getProperty("management.health.sentinel.enabled")) == null) {
            params.put("management.health.sentinel.enabled", false);
        }
    }

    private void setSentinelDataSource(Environment environment, Map<String, Object> params) {
        String group;
        String password;
        String username;
        String serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.config.server-addr:}");
        if (!StringUtils.hasText((String)serverAddr)) {
            serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:localhost:8848}");
        }
        if (!StringUtils.hasText((String)(username = environment.resolvePlaceholders("${spring.cloud.nacos.config.username:}")))) {
            username = environment.resolvePlaceholders("${spring.cloud.nacos.username:}");
        }
        if (!StringUtils.hasText((String)(password = environment.resolvePlaceholders("${spring.cloud.nacos.config.password:}")))) {
            password = environment.resolvePlaceholders("${spring.cloud.nacos.password:}");
        }
        if (!StringUtils.hasText((String)(group = environment.resolvePlaceholders("${spring.cloud.nacos.config.group:}")))) {
            group = "DEFAULT_GROUP";
        }
        String namespace = environment.resolvePlaceholders("${spring.cloud.nacos.config.namespace:}");
        String appName = environment.resolvePlaceholders("${spring.application.name:}");
        LinkedHashMap<String, String> flow = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> degrade = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> systemSentinel = new LinkedHashMap<String, String>();
        if (StringUtils.hasText((String)serverAddr)) {
            flow.put("spring.cloud.sentinel.datasource.flow.nacos.server-addr", serverAddr);
            degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.server-addr", serverAddr);
            systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.server-addr", serverAddr);
        }
        if (StringUtils.hasText((String)username)) {
            flow.put("spring.cloud.sentinel.datasource.flow.nacos.username", username);
            degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.username", username);
            systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.username", username);
        }
        if (StringUtils.hasText((String)password)) {
            flow.put("spring.cloud.sentinel.datasource.flow.nacos.password", password);
            degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.password", password);
            systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.password", password);
        }
        if (StringUtils.hasText((String)group)) {
            flow.put("spring.cloud.sentinel.datasource.flow.nacos.group-id", group);
            degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.group-id", group);
            systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.group-id", group);
        }
        if (StringUtils.hasText((String)namespace)) {
            flow.put("spring.cloud.sentinel.datasource.flow.nacos.namespace", namespace);
            degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.namespace", namespace);
            systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.namespace", namespace);
        }
        flow.put("spring.cloud.sentinel.datasource.flow.nacos.rule-type", (String)RuleType.FLOW);
        degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.rule-type", (String)RuleType.DEGRADE);
        systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.rule-type", (String)RuleType.SYSTEM);
        flow.put("spring.cloud.sentinel.datasource.flow.nacos.data-id", appName + "-udp-service-flow-in.json");
        degrade.put("spring.cloud.sentinel.datasource.degrade.nacos.data-id", appName + "-udp-service-degrade-out.json");
        systemSentinel.put("spring.cloud.sentinel.datasource.system.nacos.data-id", appName + "-udp-service-system.json");
        params.putAll(flow);
        params.putAll(degrade);
        params.putAll(systemSentinel);
    }
}

