/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.sentinel.feign;

import com.alibaba.cloud.sentinel.feign.SentinelContractHolder;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.openfeign.FallbackFactory;

public class UcSentinelInvocationHandler
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private FallbackFactory fallbackFactory;
    private Map<Method, Method> fallbackMethodMap;

    UcSentinelInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, FallbackFactory fallbackFactory) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
        this.fallbackMethodMap = UcSentinelInvocationHandler.toFallbackMethod(dispatch);
    }

    UcSentinelInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if ("equals".equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        InvocationHandlerFactory.MethodHandler methodHandler = this.dispatch.get(method);
        if (this.target instanceof Target.HardCodedTarget) {
            Target.HardCodedTarget hardCodedTarget = (Target.HardCodedTarget)this.target;
            MethodMetadata methodMetadata = (MethodMetadata)SentinelContractHolder.METADATA_MAP.get(hardCodedTarget.type().getName() + Feign.configKey((Class)hardCodedTarget.type(), (Method)method));
            if (methodMetadata == null) {
                result = methodHandler.invoke(args);
            } else {
                String resourceName = methodMetadata.template().method().toUpperCase() + ":" + hardCodedTarget.url() + methodMetadata.template().path();
                this.fixRule(resourceName);
                Entry entry = null;
                try {
                    ContextUtil.enter((String)resourceName);
                    entry = SphU.entry((String)resourceName, (EntryType)EntryType.OUT, (int)1, (Object[])args);
                    result = methodHandler.invoke(args);
                }
                catch (Throwable ex) {
                    if (!BlockException.isBlockException((Throwable)ex)) {
                        Tracer.traceEntry((Throwable)ex, (Entry)entry);
                    }
                    if (this.fallbackFactory != null) {
                        try {
                            Object fallbackResult;
                            Object object = fallbackResult = this.fallbackMethodMap.get(method).invoke(this.fallbackFactory.create(ex), args);
                            return object;
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new AssertionError((Object)e.getCause());
                        }
                    }
                    throw ex;
                }
                finally {
                    if (entry != null) {
                        entry.exit(1, args);
                    }
                    ContextUtil.exit();
                }
            }
        } else {
            result = methodHandler.invoke(args);
        }
        return result;
    }

    protected void fixRule(String resourceName) {
        if (DegradeRuleManager.hasConfig((String)resourceName)) {
            return;
        }
        if (!DegradeRuleManager.hasConfig((String)"DEGRADE:*")) {
            return;
        }
        List rules = DegradeRuleManager.getRules();
        DegradeRule defaultRule = null;
        for (DegradeRule rule : rules) {
            String resource = rule.getResource();
            if (!resource.equals("DEGRADE:*")) continue;
            defaultRule = rule;
        }
        if (defaultRule != null) {
            DegradeRule newRule = new DegradeRule();
            BeanUtils.copyProperties(defaultRule, (Object)newRule);
            newRule.setResource(resourceName);
            rules.add(newRule);
            DegradeRuleManager.loadRules((List)rules);
            this.logger.info("[udp-cloud]: register degrade rule [{}]", (Object)resourceName);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UcSentinelInvocationHandler) {
            UcSentinelInvocationHandler other = (UcSentinelInvocationHandler)obj;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    static Map<Method, Method> toFallbackMethod(Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        LinkedHashMap<Method, Method> result = new LinkedHashMap<Method, Method>();
        for (Method method : dispatch.keySet()) {
            method.setAccessible(true);
            result.put(method, method);
        }
        return result;
    }
}

