/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.sentinel;

import cn.com.yusys.udp.cloud.sentinel.UcSentinelProperties;
import cn.com.yusys.udp.cloud.sentinel.UcSentinelWebMvcConfigurer;
import cn.com.yusys.udp.cloud.sentinel.web.UcSentinelWebInterceptor;
import cn.com.yusys.udp.cloud.sentinel.web.UcSentinelWebMvcConfig;
import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.cloud.sentinel.SentinelWebAutoConfiguration;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.DefaultBlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.UrlCleaner;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={SentinelWebAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcSentinelProperties.class})
public class UcSentinelWebAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SentinelProperties properties;
    @Autowired
    private Optional<UrlCleaner> urlCleanerOptional;
    @Autowired
    private Optional<BlockExceptionHandler> blockExceptionHandlerOptional;
    @Autowired
    private Optional<RequestOriginParser> requestOriginParserOptional;

    @Bean
    public UcSentinelWebInterceptor ucSentinelWebInterceptor(UcSentinelWebMvcConfig sentinelWebMvcConfig) {
        return new UcSentinelWebInterceptor(sentinelWebMvcConfig);
    }

    @Bean
    public UcSentinelWebMvcConfig ucSentinelWebMvcConfig() {
        UcSentinelWebMvcConfig ucSentinelWebMvcConfig = new UcSentinelWebMvcConfig();
        ucSentinelWebMvcConfig.setHttpMethodSpecify(this.properties.getHttpMethodSpecify());
        ucSentinelWebMvcConfig.setWebContextUnify(this.properties.getWebContextUnify());
        if (this.blockExceptionHandlerOptional.isPresent()) {
            this.blockExceptionHandlerOptional.ifPresent(arg_0 -> ((UcSentinelWebMvcConfig)ucSentinelWebMvcConfig).setBlockExceptionHandler(arg_0));
        } else if (StringUtils.hasText((String)this.properties.getBlockPage())) {
            ucSentinelWebMvcConfig.setBlockExceptionHandler((request, response, e) -> response.sendRedirect(this.properties.getBlockPage()));
        } else {
            ucSentinelWebMvcConfig.setBlockExceptionHandler((BlockExceptionHandler)new DefaultBlockExceptionHandler());
        }
        this.urlCleanerOptional.ifPresent(ucSentinelWebMvcConfig::setUrlCleaner);
        this.requestOriginParserOptional.ifPresent(arg_0 -> ((UcSentinelWebMvcConfig)ucSentinelWebMvcConfig).setOriginParser(arg_0));
        return ucSentinelWebMvcConfig;
    }

    @Bean
    public UcSentinelWebMvcConfigurer ucSentinelWebMvcConfigurer() {
        return new UcSentinelWebMvcConfigurer();
    }
}

