/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.sentinel.actuate;

import com.alibaba.cloud.sentinel.feign.SentinelContractHolder;
import feign.Feign;
import feign.MethodMetadata;
import feign.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.GetMapping;

@RestControllerEndpoint(id="ucsentinel")
public class UcSentinelControllerEndpoint {
    @Autowired
    private ApplicationContext applicationContext;

    @GetMapping(value={"/degrade/resources"})
    public Map<String, Set<String>> degradeResources() {
        LinkedHashMap<String, Set<String>> rt = new LinkedHashMap<String, Set<String>>();
        List<Target.HardCodedTarget<?>> targets = this.getFeignTargets();
        for (Target.HardCodedTarget<?> target : targets) {
            String name = this.getServerName(target);
            rt.computeIfAbsent(name, k -> new LinkedHashSet());
            Set resources = (Set)rt.get(name);
            for (Method method : target.type().getDeclaredMethods()) {
                MethodMetadata methodMetadata = (MethodMetadata)SentinelContractHolder.METADATA_MAP.get(target.type().getName() + Feign.configKey((Class)target.type(), (Method)method));
                if (methodMetadata == null) continue;
                String resourceName = methodMetadata.template().method().toUpperCase() + ":" + target.url() + methodMetadata.template().path();
                resources.add(resourceName);
            }
        }
        return rt;
    }

    private String getServerName(Target.HardCodedTarget<?> target) {
        String name;
        try {
            name = new URI(target.url()).getHost();
        }
        catch (URISyntaxException e) {
            name = target.name();
        }
        return name;
    }

    private List<Target.HardCodedTarget<?>> getFeignTargets() {
        String[] clientNames;
        ArrayList targets = new ArrayList();
        for (String client : clientNames = this.applicationContext.getBeanNamesForAnnotation(FeignClient.class)) {
            InvocationHandler ih;
            Field targetField;
            Object bean = this.applicationContext.getBean(client);
            if (!Proxy.isProxyClass(bean.getClass()) || (targetField = ReflectionUtils.findField((ih = Proxy.getInvocationHandler(bean)).getClass(), (String)"target")) == null) continue;
            targetField.setAccessible(true);
            Target target = (Target)ReflectionUtils.getField((Field)targetField, (Object)ih);
            if (!(target instanceof Target.HardCodedTarget)) continue;
            targets.add((Target.HardCodedTarget)target);
        }
        return targets;
    }
}

