/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.sentinel;

import cn.com.yusys.udp.cloud.sentinel.feign.UcSentinelFeign;
import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.SphU;
import feign.Feign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SphU.class, Feign.class})
@AutoConfigureBefore(value={SentinelFeignAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.sentinel-enabled"}, matchIfMissing=true)
public class UcSentinelFeignAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @Scope(value="prototype")
    @ConditionalOnProperty(name={"feign.sentinel.enabled"})
    public Feign.Builder feignSentinelBuilder() {
        this.logger.info("[udp-cloud]: register UcSentinelFeign.Builder");
        return UcSentinelFeign.builder();
    }
}

