/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.feign.exception;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.utils.ExceptionUtils;
import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignErrorDecoder
implements ErrorDecoder {
    private final Logger logger = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        String exceptionClass = FeignErrorDecoder.getExceptionInfo("cn.com.yusys.yusp.commons.exception-class", response);
        if (ExceptionUtils.isBizException((String)exceptionClass)) {
            try {
                String code = FeignErrorDecoder.getExceptionInfo("cn.com.yusys.yusp.commons.exception-code", response);
                String message = FeignErrorDecoder.getExceptionInfo("cn.com.yusys.yusp.commons.exception-message", response);
                String errorCode = FeignErrorDecoder.getExceptionInfo("cn.com.yusys.yusp.commons.exception-error", response);
                message = URLDecoder.decode(message, "UTF-8");
                return BizException.error((String)code, (String)errorCode, (Object[])new Object[]{message});
            }
            catch (Exception e) {
                this.logger.warn("500 feign decoder exception error.");
            }
        } else if (ExceptionUtils.isPlatformException((String)exceptionClass)) {
            try {
                String message = URLDecoder.decode(FeignErrorDecoder.getExceptionInfo("cn.com.yusys.yusp.commons.exception-message", response), "UTF-8");
                return new PlatformException(message);
            }
            catch (Exception e) {
                this.logger.warn("500 feign decoder exception error.");
            }
        }
        return FeignException.errorStatus((String)methodKey, (Response)response);
    }

    static String getExceptionInfo(String key, Response response) {
        return FeignErrorDecoder.getExceptionInfo(response, (T r) -> (Collection)r.headers().get(key));
    }

    public static <T> String getExceptionInfo(T t, Function<T, Collection<String>> function) {
        Collection<String> infos = function.apply(t);
        return Objects.isNull(infos) || infos.isEmpty() ? null : infos.iterator().next();
    }
}

