/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.feign.configura;

import cn.com.yusys.udp.cloud.feign.configura.FeignBeanPostProcessor;
import cn.com.yusys.udp.cloud.feign.interceptor.FeignInterceptor;
import cn.com.yusys.udp.cloud.feign.interceptor.i18n.AcceptLanguageRequestInterceptor;
import cn.com.yusys.udp.cloud.feign.ip.IpFeignInterceptor;
import cn.com.yusys.udp.cloud.feign.mock.FeignMockStrategy;
import cn.com.yusys.udp.cloud.feign.mock.MockInterceptor;
import cn.com.yusys.udp.cloud.feign.mock.filter.MockFilter;
import cn.com.yusys.udp.cloud.feign.mock.store.MockDataStore;
import cn.com.yusys.udp.cloud.feign.mock.store.impl.MapMockDataStore;
import cn.com.yusys.udp.cloud.feign.mock.strategy.DefaultFeignMockStrategy;
import cn.com.yusys.udp.cloud.feign.mock.web.MockDataController;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Feign;
import feign.RequestInterceptor;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={Feign.class, FeignContext.class, FeignInterceptor.class})
public class YuFeignAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(YuFeignAutoConfiguration.class);

    @Bean
    public RequestInterceptor acceptLanguageRequestInterceptor() {
        return new AcceptLanguageRequestInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public IpFeignInterceptor ipFeignInterceptor(Environment env) {
        return new IpFeignInterceptor(env);
    }

    @Configuration
    @ConditionalOnClass(value={MockInterceptor.class})
    @ConditionalOnProperty(value={"udp.feign.mock.enabled"}, havingValue="true")
    public class FeignMockConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public MockDataStore mapMockStore() {
            logger.debug("Load default MapMockDataStore");
            return new MapMockDataStore();
        }

        @Bean
        @ConditionalOnMissingBean
        public MockDataController mockDataController(MockDataStore mockDataStore) {
            logger.debug("Load default MapMockDataStore");
            return new MockDataController(mockDataStore);
        }

        @Bean
        @ConditionalOnMissingBean
        public FeignMockStrategy feignMockStrategy(ObjectMapper objectMapper) {
            logger.debug("Load DefaultFeignMockStrategy");
            return new DefaultFeignMockStrategy(objectMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        public MockInterceptor mockInterceptor(MockDataStore dataStore, FeignMockStrategy feignMockStrategy) {
            logger.debug("Load Mock Feign Interceptor");
            return new MockInterceptor(dataStore, feignMockStrategy);
        }

        @Bean
        @ConditionalOnMissingBean
        public MockFilter mockFilter() {
            logger.debug("Load mock filter, it control current request feign invoke will be mock or false");
            return new MockFilter();
        }

        @Bean
        public FilterRegistrationBean<MockFilter> mockFilterFilterRegistrationBean(Environment environment) {
            logger.debug("Load filter in servlet filter");
            FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)this.mockFilter(), new ServletRegistrationBean[0]);
            int order = (Integer)environment.getProperty("udp.feign.mock.order", Integer.class, (Object)10);
            registrationBean.setOrder(order);
            return registrationBean;
        }
    }

    @Configuration
    public class FeignInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public FeignBeanPostProcessor feignMockBeanPostProcessor(ObjectProvider<List<FeignInterceptor>> feignInterceptorProvider) {
            List interceptors = (List)feignInterceptorProvider.getIfAvailable();
            if (interceptors != null && !interceptors.isEmpty()) {
                AnnotationAwareOrderComparator.sort((List)interceptors);
            }
            logger.debug("Load Feign Object Plugin Proxy");
            return new FeignBeanPostProcessor(interceptors);
        }
    }
}

