/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.util;

import cn.com.yusys.udp.cloud.message.exception.StoreException;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class QueueAckUtils {
    private static final Logger log = LoggerFactory.getLogger(QueueAckUtils.class);

    private QueueAckUtils() {
    }

    public static void ack(Message<?> message) {
        QueueAckUtils.internalAck(message, (deliveryTag, channel) -> {
            try {
                channel.basicAck(deliveryTag.longValue(), false);
            }
            catch (IOException e) {
                log.error(String.format("channel: %s ack message error: %s", channel, message), (Throwable)e);
            }
        });
    }

    public static void nack(Message<?> message, boolean requeue) {
        QueueAckUtils.internalAck(message, (deliveryTag, channel) -> {
            try {
                channel.basicReject(deliveryTag.longValue(), requeue);
                log.info("reject message requeue:{}.", (Object)requeue);
            }
            catch (IOException e) {
                log.error(String.format("channel: %s ack message error:", message), (Throwable)e);
            }
        });
    }

    private static void internalAck(Message<?> message, BiConsumer<Long, Channel> consumer) {
        MessageHeaders headers = message.getHeaders();
        Channel channel = (Channel)headers.get((Object)"amqp_channel", Channel.class);
        Long deliveryTag = (Long)headers.get((Object)"amqp_deliveryTag", Long.class);
        if (channel == null || deliveryTag == null) {
            log.info("Not Exists ack channel, do not manual nack.");
            return;
        }
        consumer.accept(deliveryTag, channel);
    }

    public static void recordBizLog(Exception e, Message<?> message) {
        log.error("\u6d88\u606f\u7ec4\u4ef6\u6d88\u8d39\u5f02\u5e38.", (Throwable)QueueAckUtils.wrapStoreException(e, message));
    }

    static StoreException wrapStoreException(Exception e, Message<?> message) {
        return new StoreException(e, MessageHeaderUtils.event(message), MessageHeaderUtils.bizSeq(message));
    }
}

